/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.storage.NameMappingService;
import org.apache.gravitino.storage.kv.BinaryEntityKeyEncoder;

public class BinaryEntityEncoderUtil {
    public static final Set<Entity.EntityType> VERSION_0_4_COMPATIBLE_ENTITY_TYPES = ImmutableSet.of((Object)((Object)Entity.EntityType.METALAKE), (Object)((Object)Entity.EntityType.CATALOG), (Object)((Object)Entity.EntityType.SCHEMA), (Object)((Object)Entity.EntityType.TABLE));

    private BinaryEntityEncoderUtil() {
    }

    public static String generateKeyForMapping(NameIdentifier nameIdentifier, Entity.EntityType entityType, NameMappingService nameMappingService) throws IOException {
        Namespace namespace = nameIdentifier.namespace();
        String name = nameIdentifier.name();
        List<Entity.EntityType> parentTypes = Entity.EntityType.getParentEntityTypes(entityType);
        long[] ids = new long[namespace.length()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = nameMappingService.getIdByName(BinaryEntityEncoderUtil.concatIdAndName(ArrayUtils.subarray((long[])ids, (int)0, (int)i), namespace.level(i), parentTypes.get(i)));
        }
        return BinaryEntityEncoderUtil.concatIdAndName(ids, name, entityType);
    }

    public static String concatIdAndName(long[] namespaceIds, String name, Entity.EntityType type) {
        String context = Joiner.on((String)"/").join((Iterable)Arrays.stream(namespaceIds).mapToObj(String::valueOf).collect(Collectors.toList()));
        String mappingName = VERSION_0_4_COMPATIBLE_ENTITY_TYPES.contains((Object)type) ? name : type.getShortName() + "_" + name;
        return StringUtils.isBlank((CharSequence)context) ? mappingName : context + "/" + mappingName;
    }

    public static List<byte[]> getSubEntitiesPrefix(NameIdentifier ident, Entity.EntityType type, BinaryEntityKeyEncoder entityKeyEncoder) throws IOException {
        ArrayList prefixes = Lists.newArrayList();
        byte[] encode = entityKeyEncoder.encode(ident, type, true);
        switch (type) {
            case METALAKE: {
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.CATALOG.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.SCHEMA.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.TABLE.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.FILESET.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.TOPIC.getShortName()));
                break;
            }
            case CATALOG: {
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.SCHEMA.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.TABLE.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.FILESET.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.TOPIC.getShortName()));
                break;
            }
            case SCHEMA: {
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.TABLE.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.FILESET.getShortName()));
                prefixes.add(BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, Entity.EntityType.TOPIC.getShortName()));
                break;
            }
            case TABLE: 
            case FILESET: 
            case TOPIC: {
                break;
            }
            default: {
                BinaryEntityKeyEncoder.LOG.warn("Currently unknown type: {}, please check it", (Object)type);
            }
        }
        Collections.reverse(prefixes);
        return prefixes;
    }

    public static byte[] replacePrefixTypeInfo(byte[] encode, String subTypePrefix) {
        byte[] result = new byte[encode.length];
        System.arraycopy(encode, 0, result, 0, encode.length);
        byte[] bytes = subTypePrefix.getBytes(StandardCharsets.UTF_8);
        result[0] = bytes[0];
        result[1] = bytes[1];
        return result;
    }
}

