/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface GroupMetaMapper {
    public static final String GROUP_TABLE_NAME = "group_meta";
    public static final String GROUP_ROLE_RELATION_TABLE_NAME = "group_role_rel";

    @Select(value={"SELECT group_id as groupId FROM group_meta WHERE metalake_id = #{metalakeId} AND group_name = #{groupName} AND deleted_at = 0"})
    public Long selectGroupIdBySchemaIdAndName(@Param(value="metalakeId") Long var1, @Param(value="groupName") String var2);

    @Select(value={"SELECT group_id as groupId, group_name as groupName, metalake_id as metalakeId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM group_meta WHERE metalake_id = #{metalakeId} AND group_name = #{groupName} AND deleted_at = 0"})
    public GroupPO selectGroupMetaByMetalakeIdAndName(@Param(value="metalakeId") Long var1, @Param(value="groupName") String var2);

    @Insert(value={"INSERT INTO group_meta(group_id, group_name, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{groupMeta.groupId}, #{groupMeta.groupName}, #{groupMeta.metalakeId}, #{groupMeta.auditInfo}, #{groupMeta.currentVersion}, #{groupMeta.lastVersion}, #{groupMeta.deletedAt} )"})
    public void insertGroupMeta(@Param(value="groupMeta") GroupPO var1);

    @Insert(value={"INSERT INTO group_meta(group_id, group_name,metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{groupMeta.groupId}, #{groupMeta.groupName}, #{groupMeta.metalakeId}, #{groupMeta.auditInfo}, #{groupMeta.currentVersion}, #{groupMeta.lastVersion}, #{groupMeta.deletedAt} ) ON DUPLICATE KEY UPDATE group_name = #{groupMeta.groupName}, metalake_id = #{groupMeta.metalakeId}, audit_info = #{groupMeta.auditInfo}, current_version = #{groupMeta.currentVersion}, last_version = #{groupMeta.lastVersion}, deleted_at = #{groupMeta.deletedAt}"})
    public void insertGroupMetaOnDuplicateKeyUpdate(@Param(value="groupMeta") GroupPO var1);

    @Update(value={"UPDATE group_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE group_id = #{groupId} AND deleted_at = 0"})
    public void softDeleteGroupMetaByGroupId(@Param(value="groupId") Long var1);

    @Update(value={"UPDATE group_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public void softDeleteGroupMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE group_meta SET group_name = #{newGroupMeta.groupName}, metalake_id = #{newGroupMeta.metalakeId}, audit_info = #{newGroupMeta.auditInfo}, current_version = #{newGroupMeta.currentVersion}, last_version = #{newGroupMeta.lastVersion}, deleted_at = #{newGroupMeta.deletedAt} WHERE group_id = #{oldGroupMeta.groupId} AND group_name = #{oldGroupMeta.groupName} AND metalake_id = #{oldGroupMeta.metalakeId} AND audit_info = #{oldGroupMeta.auditInfo} AND current_version = #{oldGroupMeta.currentVersion} AND last_version = #{oldGroupMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateGroupMeta(@Param(value="newGroupMeta") GroupPO var1, @Param(value="oldGroupMeta") GroupPO var2);

    @Select(value={"SELECT gr.group_id as groupId, gr.group_name as groupName, gr.metalake_id as metalakeId, gr.audit_info as auditInfo, gr.current_version as currentVersion, gr.last_version as lastVersion, gr.deleted_at as deletedAt FROM group_meta gr JOIN group_role_rel re ON gr.group_id = re.group_id WHERE re.role_id = #{roleId} AND gr.deleted_at = 0 AND re.deleted_at = 0"})
    public List<GroupPO> listGroupsByRoleId(@Param(value="roleId") Long var1);

    @Delete(value={"DELETE FROM group_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteGroupMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

