/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import java.util.Objects;
import org.apache.gravitino.authorization.Privilege;

public class Privileges {
    public static Privilege allow(String privilege) {
        Privilege.Name name = Privilege.Name.valueOf(privilege);
        return Privileges.allow(name);
    }

    public static Privilege allow(Privilege.Name name) {
        switch (name) {
            case CREATE_CATALOG: {
                return CreateCatalog.allow();
            }
            case USE_CATALOG: {
                return UseCatalog.allow();
            }
            case CREATE_SCHEMA: {
                return CreateSchema.allow();
            }
            case USE_SCHEMA: {
                return UseSchema.allow();
            }
            case CREATE_TABLE: {
                return CreateTable.allow();
            }
            case MODIFY_TABLE: {
                return ModifyTable.allow();
            }
            case SELECT_TABLE: {
                return SelectTable.allow();
            }
            case CREATE_FILESET: {
                return CreateFileset.allow();
            }
            case WRITE_FILESET: {
                return WriteFileset.allow();
            }
            case READ_FILESET: {
                return ReadFileset.allow();
            }
            case CREATE_TOPIC: {
                return CreateTopic.allow();
            }
            case PRODUCE_TOPIC: {
                return ProduceTopic.allow();
            }
            case CONSUME_TOPIC: {
                return ConsumeTopic.allow();
            }
            case MANAGE_USERS: {
                return ManageUsers.allow();
            }
            case MANAGE_GROUPS: {
                return ManageGroups.allow();
            }
            case CREATE_ROLE: {
                return CreateRole.allow();
            }
            case MANAGE_GRANTS: {
                return ManageGrants.allow();
            }
        }
        throw new IllegalArgumentException("Doesn't support the privilege: " + (Object)((Object)name));
    }

    public static Privilege deny(String privilege) {
        Privilege.Name name = Privilege.Name.valueOf(privilege);
        return Privileges.deny(name);
    }

    public static Privilege deny(Privilege.Name name) {
        switch (name) {
            case CREATE_CATALOG: {
                return CreateCatalog.deny();
            }
            case USE_CATALOG: {
                return UseCatalog.deny();
            }
            case CREATE_SCHEMA: {
                return CreateSchema.deny();
            }
            case USE_SCHEMA: {
                return UseSchema.deny();
            }
            case CREATE_TABLE: {
                return CreateTable.deny();
            }
            case MODIFY_TABLE: {
                return ModifyTable.deny();
            }
            case SELECT_TABLE: {
                return SelectTable.deny();
            }
            case CREATE_FILESET: {
                return CreateFileset.deny();
            }
            case WRITE_FILESET: {
                return WriteFileset.deny();
            }
            case READ_FILESET: {
                return ReadFileset.deny();
            }
            case CREATE_TOPIC: {
                return CreateTopic.deny();
            }
            case PRODUCE_TOPIC: {
                return ProduceTopic.deny();
            }
            case CONSUME_TOPIC: {
                return ConsumeTopic.deny();
            }
            case MANAGE_USERS: {
                return ManageUsers.deny();
            }
            case MANAGE_GROUPS: {
                return ManageGroups.deny();
            }
            case CREATE_ROLE: {
                return CreateRole.deny();
            }
            case MANAGE_GRANTS: {
                return ManageGrants.deny();
            }
        }
        throw new IllegalArgumentException("Doesn't support the privilege: " + (Object)((Object)name));
    }

    public static class ManageGrants
    extends GenericPrivilege<ManageGrants> {
        private static final ManageGrants ALLOW_INSTANCE = new ManageGrants(Privilege.Condition.ALLOW, Privilege.Name.MANAGE_GRANTS);
        private static final ManageGrants DENY_INSTANCE = new ManageGrants(Privilege.Condition.DENY, Privilege.Name.MANAGE_GRANTS);

        private ManageGrants(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static ManageGrants allow() {
            return ALLOW_INSTANCE;
        }

        public static ManageGrants deny() {
            return DENY_INSTANCE;
        }
    }

    public static class CreateRole
    extends GenericPrivilege<CreateRole> {
        private static final CreateRole ALLOW_INSTANCE = new CreateRole(Privilege.Condition.ALLOW, Privilege.Name.CREATE_ROLE);
        private static final CreateRole DENY_INSTANCE = new CreateRole(Privilege.Condition.DENY, Privilege.Name.CREATE_ROLE);

        private CreateRole(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static CreateRole allow() {
            return ALLOW_INSTANCE;
        }

        public static CreateRole deny() {
            return DENY_INSTANCE;
        }
    }

    public static class ManageGroups
    extends GenericPrivilege<ManageGroups> {
        private static final ManageGroups ALLOW_INSTANCE = new ManageGroups(Privilege.Condition.ALLOW, Privilege.Name.MANAGE_GROUPS);
        private static final ManageGroups DENY_INSTANCE = new ManageGroups(Privilege.Condition.DENY, Privilege.Name.MANAGE_GROUPS);

        private ManageGroups(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static ManageGroups allow() {
            return ALLOW_INSTANCE;
        }

        public static ManageGroups deny() {
            return DENY_INSTANCE;
        }
    }

    public static class ManageUsers
    extends GenericPrivilege<ManageUsers> {
        private static final ManageUsers ALLOW_INSTANCE = new ManageUsers(Privilege.Condition.ALLOW, Privilege.Name.MANAGE_USERS);
        private static final ManageUsers DENY_INSTANCE = new ManageUsers(Privilege.Condition.DENY, Privilege.Name.MANAGE_USERS);

        private ManageUsers(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static ManageUsers allow() {
            return ALLOW_INSTANCE;
        }

        public static ManageUsers deny() {
            return DENY_INSTANCE;
        }
    }

    public static class ProduceTopic
    extends GenericPrivilege<ProduceTopic> {
        private static final ProduceTopic ALLOW_INSTANCE = new ProduceTopic(Privilege.Condition.ALLOW, Privilege.Name.PRODUCE_TOPIC);
        private static final ProduceTopic DENY_INSTANCE = new ProduceTopic(Privilege.Condition.DENY, Privilege.Name.PRODUCE_TOPIC);

        private ProduceTopic(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static ProduceTopic allow() {
            return ALLOW_INSTANCE;
        }

        public static ProduceTopic deny() {
            return DENY_INSTANCE;
        }
    }

    public static class ConsumeTopic
    extends GenericPrivilege<ConsumeTopic> {
        private static final ConsumeTopic ALLOW_INSTANCE = new ConsumeTopic(Privilege.Condition.ALLOW, Privilege.Name.CONSUME_TOPIC);
        private static final ConsumeTopic DENY_INSTANCE = new ConsumeTopic(Privilege.Condition.DENY, Privilege.Name.CONSUME_TOPIC);

        private ConsumeTopic(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static ConsumeTopic allow() {
            return ALLOW_INSTANCE;
        }

        public static ConsumeTopic deny() {
            return DENY_INSTANCE;
        }
    }

    public static class CreateTopic
    extends GenericPrivilege<CreateTopic> {
        private static final CreateTopic ALLOW_INSTANCE = new CreateTopic(Privilege.Condition.ALLOW, Privilege.Name.CREATE_TOPIC);
        private static final CreateTopic DENY_INSTANCE = new CreateTopic(Privilege.Condition.DENY, Privilege.Name.CREATE_TOPIC);

        private CreateTopic(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static CreateTopic allow() {
            return ALLOW_INSTANCE;
        }

        public static CreateTopic deny() {
            return DENY_INSTANCE;
        }
    }

    public static class WriteFileset
    extends GenericPrivilege<WriteFileset> {
        private static final WriteFileset ALLOW_INSTANCE = new WriteFileset(Privilege.Condition.ALLOW, Privilege.Name.WRITE_FILESET);
        private static final WriteFileset DENY_INSTANCE = new WriteFileset(Privilege.Condition.DENY, Privilege.Name.WRITE_FILESET);

        private WriteFileset(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static WriteFileset allow() {
            return ALLOW_INSTANCE;
        }

        public static WriteFileset deny() {
            return DENY_INSTANCE;
        }
    }

    public static class ReadFileset
    extends GenericPrivilege<ReadFileset> {
        private static final ReadFileset ALLOW_INSTANCE = new ReadFileset(Privilege.Condition.ALLOW, Privilege.Name.READ_FILESET);
        private static final ReadFileset DENY_INSTANCE = new ReadFileset(Privilege.Condition.DENY, Privilege.Name.READ_FILESET);

        private ReadFileset(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static ReadFileset allow() {
            return ALLOW_INSTANCE;
        }

        public static ReadFileset deny() {
            return DENY_INSTANCE;
        }
    }

    public static class CreateFileset
    extends GenericPrivilege<CreateFileset> {
        private static final CreateFileset ALLOW_INSTANCE = new CreateFileset(Privilege.Condition.ALLOW, Privilege.Name.CREATE_FILESET);
        private static final CreateFileset DENY_INSTANCE = new CreateFileset(Privilege.Condition.DENY, Privilege.Name.CREATE_FILESET);

        private CreateFileset(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static CreateFileset allow() {
            return ALLOW_INSTANCE;
        }

        public static CreateFileset deny() {
            return DENY_INSTANCE;
        }
    }

    public static class ModifyTable
    extends GenericPrivilege<ModifyTable> {
        private static final ModifyTable ALLOW_INSTANCE = new ModifyTable(Privilege.Condition.ALLOW, Privilege.Name.MODIFY_TABLE);
        private static final ModifyTable DENY_INSTANCE = new ModifyTable(Privilege.Condition.DENY, Privilege.Name.MODIFY_TABLE);

        private ModifyTable(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static ModifyTable allow() {
            return ALLOW_INSTANCE;
        }

        public static ModifyTable deny() {
            return DENY_INSTANCE;
        }
    }

    public static class SelectTable
    extends GenericPrivilege<SelectTable> {
        private static final SelectTable ALLOW_INSTANCE = new SelectTable(Privilege.Condition.ALLOW, Privilege.Name.SELECT_TABLE);
        private static final SelectTable DENY_INSTANCE = new SelectTable(Privilege.Condition.DENY, Privilege.Name.SELECT_TABLE);

        private SelectTable(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static SelectTable allow() {
            return ALLOW_INSTANCE;
        }

        public static SelectTable deny() {
            return DENY_INSTANCE;
        }
    }

    public static class CreateTable
    extends GenericPrivilege<CreateTable> {
        private static final CreateTable ALLOW_INSTANCE = new CreateTable(Privilege.Condition.ALLOW, Privilege.Name.CREATE_TABLE);
        private static final CreateTable DENY_INSTANCE = new CreateTable(Privilege.Condition.DENY, Privilege.Name.CREATE_TABLE);

        private CreateTable(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static CreateTable allow() {
            return ALLOW_INSTANCE;
        }

        public static CreateTable deny() {
            return DENY_INSTANCE;
        }
    }

    public static class CreateSchema
    extends GenericPrivilege<CreateSchema> {
        private static final CreateSchema ALLOW_INSTANCE = new CreateSchema(Privilege.Condition.ALLOW, Privilege.Name.CREATE_SCHEMA);
        private static final CreateSchema DENY_INSTANCE = new CreateSchema(Privilege.Condition.DENY, Privilege.Name.CREATE_SCHEMA);

        private CreateSchema(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static CreateSchema allow() {
            return ALLOW_INSTANCE;
        }

        public static CreateSchema deny() {
            return DENY_INSTANCE;
        }
    }

    public static class UseSchema
    extends GenericPrivilege<UseSchema> {
        private static final UseSchema ALLOW_INSTANCE = new UseSchema(Privilege.Condition.ALLOW, Privilege.Name.USE_SCHEMA);
        private static final UseSchema DENY_INSTANCE = new UseSchema(Privilege.Condition.DENY, Privilege.Name.USE_SCHEMA);

        private UseSchema(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static UseSchema allow() {
            return ALLOW_INSTANCE;
        }

        public static UseSchema deny() {
            return DENY_INSTANCE;
        }
    }

    public static class UseCatalog
    extends GenericPrivilege<UseCatalog> {
        private static final UseCatalog ALLOW_INSTANCE = new UseCatalog(Privilege.Condition.ALLOW, Privilege.Name.USE_CATALOG);
        private static final UseCatalog DENY_INSTANCE = new UseCatalog(Privilege.Condition.DENY, Privilege.Name.USE_CATALOG);

        private UseCatalog(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static UseCatalog allow() {
            return ALLOW_INSTANCE;
        }

        public static UseCatalog deny() {
            return DENY_INSTANCE;
        }
    }

    public static class CreateCatalog
    extends GenericPrivilege<CreateCatalog> {
        private static final CreateCatalog ALLOW_INSTANCE = new CreateCatalog(Privilege.Condition.ALLOW, Privilege.Name.CREATE_CATALOG);
        private static final CreateCatalog DENY_INSTANCE = new CreateCatalog(Privilege.Condition.DENY, Privilege.Name.CREATE_CATALOG);

        private CreateCatalog(Privilege.Condition condition, Privilege.Name name) {
            super(condition, name);
        }

        public static CreateCatalog allow() {
            return ALLOW_INSTANCE;
        }

        public static CreateCatalog deny() {
            return DENY_INSTANCE;
        }
    }

    public static abstract class GenericPrivilege<T extends GenericPrivilege<T>>
    implements Privilege {
        private final Privilege.Condition condition;
        private final Privilege.Name name;

        protected GenericPrivilege(Privilege.Condition condition, Privilege.Name name) {
            this.condition = condition;
            this.name = name;
        }

        @Override
        public Privilege.Name name() {
            return this.name;
        }

        @Override
        public Privilege.Condition condition() {
            return this.condition;
        }

        @Override
        public String simpleString() {
            return this.condition.name() + " " + this.name.name().toLowerCase().replace('_', ' ');
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GenericPrivilege)) {
                return false;
            }
            GenericPrivilege that = (GenericPrivilege)o;
            return this.condition == that.condition && this.name == that.name;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.condition, this.name});
        }
    }
}

