/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTResponse;

public class ConfigResponse
implements RESTResponse {
    private Map<String, String> defaults;
    private Map<String, String> overrides;

    public ConfigResponse() {
    }

    private ConfigResponse(Map<String, String> defaults, Map<String, String> overrides) {
        this.defaults = defaults;
        this.overrides = overrides;
        this.validate();
    }

    @Override
    public void validate() {
    }

    public Map<String, String> defaults() {
        return this.defaults != null ? this.defaults : ImmutableMap.of();
    }

    public Map<String, String> overrides() {
        return this.overrides != null ? this.overrides : ImmutableMap.of();
    }

    public Map<String, String> merge(Map<String, String> clientProperties) {
        Preconditions.checkNotNull(clientProperties, (Object)"Cannot merge client properties with server-provided properties. Invalid client configuration: null");
        HashMap merged = this.defaults != null ? Maps.newHashMap(this.defaults) : Maps.newHashMap();
        merged.putAll(clientProperties);
        if (this.overrides != null) {
            merged.putAll(this.overrides);
        }
        return ImmutableMap.copyOf((Map)Maps.filterValues((Map)merged, Objects::nonNull));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("defaults", this.defaults).add("overrides", this.overrides).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> defaults = Maps.newHashMap();
        private final Map<String, String> overrides = Maps.newHashMap();

        private Builder() {
        }

        public Builder withDefault(String key, String value) {
            Preconditions.checkNotNull((Object)key, (Object)"Invalid default property: null");
            this.defaults.put(key, value);
            return this;
        }

        public Builder withOverride(String key, String value) {
            Preconditions.checkNotNull((Object)key, (Object)"Invalid override property: null");
            this.overrides.put(key, value);
            return this;
        }

        public Builder withDefaults(Map<String, String> defaultsToAdd) {
            Preconditions.checkNotNull(defaultsToAdd, (Object)"Invalid default properties map: null");
            Preconditions.checkArgument((!defaultsToAdd.containsKey(null) ? 1 : 0) != 0, (Object)"Invalid default property: null");
            this.defaults.putAll(defaultsToAdd);
            return this;
        }

        public Builder withOverrides(Map<String, String> overridesToAdd) {
            Preconditions.checkNotNull(overridesToAdd, (Object)"Invalid override properties map: null");
            Preconditions.checkArgument((!overridesToAdd.containsKey(null) ? 1 : 0) != 0, (Object)"Invalid override property: null");
            this.overrides.putAll(overridesToAdd);
            return this;
        }

        public ConfigResponse build() {
            return new ConfigResponse(this.defaults, this.overrides);
        }
    }
}

