/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.List;
import javax.realtime.MemoryArea;
import javolution.lang.Configurable;
import javolution.lang.Immutable;
import javolution.lang.Realtime;
import javolution.text.Cursor;
import javolution.text.Text;
import javolution.text.TextFormat;
import javolution.text.TypeFormat;
import javolution.util.FastCollection;
import javolution.util.FastTable;
import javolution.xml.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Index
extends Number
implements Comparable<Index>,
FastCollection.Record,
Realtime,
Immutable,
XMLSerializable {
    public static final Index ZERO = new Index(0);
    private static Index[] _NegativeIndices = new Index[32];
    private static int _NegativeIndicesLength;
    public static final Configurable<Integer> INITIAL_FIRST;
    private static Index[] _PositiveIndices;
    private static int _PositiveIndicesLength;
    public static final Configurable<Integer> INITIAL_LAST;
    private static final MemoryArea IMMORTAL_MEMORY;
    private final int _value;
    private static final Runnable AUGMENT_POSITIVE;
    private static final Runnable AUGMENT_NEGATIVE;
    private static final int INCREASE_AMOUNT = 32;
    static final TextFormat TEXT_FORMAT;
    private static final long serialVersionUID = 1L;

    private Index(int i) {
        this._value = i;
    }

    public static void setMinimumRange(int first, int last) {
        if (first > last) {
            throw new IllegalArgumentException();
        }
        Index.valueOf(first);
        Index.valueOf(last);
    }

    public static Index valueOf(int i) {
        return i >= 0 ? (i < _PositiveIndicesLength ? _PositiveIndices[i] : Index.createPositive(i)) : Index.valueOfNegative(-i);
    }

    public static List<Index> rangeOf(int start, int end) {
        FastTable<Index> list = FastTable.newInstance();
        for (int i = start; i < end; ++i) {
            list.add(Index.valueOf(i));
        }
        return list;
    }

    public static List<Index> valuesOf(int ... indices) {
        FastTable<Index> list = FastTable.newInstance();
        for (int i : indices) {
            list.add(Index.valueOf(i));
        }
        return list;
    }

    private static Index valueOfNegative(int i) {
        return i < _NegativeIndicesLength ? _NegativeIndices[i] : Index.createNegative(i);
    }

    private static synchronized Index createPositive(int i) {
        if (i < _PositiveIndicesLength) {
            return _PositiveIndices[i];
        }
        while (i >= _PositiveIndicesLength) {
            IMMORTAL_MEMORY.executeInArea(AUGMENT_POSITIVE);
        }
        return _PositiveIndices[i];
    }

    private static synchronized Index createNegative(int i) {
        if (i < _NegativeIndicesLength) {
            return _NegativeIndices[i];
        }
        while (i >= _NegativeIndicesLength) {
            IMMORTAL_MEMORY.executeInArea(AUGMENT_NEGATIVE);
        }
        return _NegativeIndices[i];
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public String toString() {
        return TextFormat.getInstance(Index.class).formatToString(this);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return this._value;
    }

    protected final Object readResolve() throws ObjectStreamException {
        return Index.valueOf(this._value);
    }

    @Override
    public final int compareTo(Index that) {
        return this._value - that._value;
    }

    @Override
    public final FastCollection.Record getNext() {
        return Index.valueOf(this._value + 1);
    }

    @Override
    public final FastCollection.Record getPrevious() {
        return Index.valueOf(this._value - 1);
    }

    @Override
    public Text toText() {
        return TextFormat.getInstance(Index.class).format(this);
    }

    static /* synthetic */ Index[] access$202(Index[] x0) {
        _PositiveIndices = x0;
        return x0;
    }

    static /* synthetic */ Index[] access$402(Index[] x0) {
        _NegativeIndices = x0;
        return x0;
    }

    static {
        Index._NegativeIndices[0] = ZERO;
        Index._NegativeIndices[1] = new Index(-1);
        _NegativeIndicesLength = 2;
        INITIAL_FIRST = new Configurable(new Integer(-(_NegativeIndicesLength - 1))){

            protected void notifyChange(Object oldValue, Object newValue) {
                Index.valueOf((Integer)newValue);
            }
        };
        _PositiveIndices = new Index[32];
        Index._PositiveIndices[0] = ZERO;
        for (int i = 1; i < _PositiveIndices.length; ++i) {
            Index._PositiveIndices[i] = new Index(i);
        }
        _PositiveIndicesLength = _PositiveIndices.length;
        INITIAL_LAST = new Configurable(new Integer(_PositiveIndicesLength - 1)){

            protected void notifyChange(Object oldValue, Object newValue) {
                Index.valueOf((Integer)newValue);
            }
        };
        IMMORTAL_MEMORY = MemoryArea.getMemoryArea(new Object());
        AUGMENT_POSITIVE = new Runnable(){

            public void run() {
                int n = _PositiveIndicesLength + 32;
                for (int i = _PositiveIndicesLength; i < n; ++i) {
                    Index index = new Index(i);
                    if (_PositiveIndices.length <= i) {
                        Index[] tmp = new Index[_PositiveIndices.length * 2];
                        System.arraycopy(_PositiveIndices, 0, tmp, 0, _PositiveIndices.length);
                        Index.access$202(tmp);
                    }
                    _PositiveIndices[i] = index;
                }
                _PositiveIndicesLength += 32;
            }
        };
        AUGMENT_NEGATIVE = new Runnable(){

            public void run() {
                int n = _NegativeIndicesLength + 32;
                for (int i = _NegativeIndicesLength; i < n; ++i) {
                    Index index = new Index(-i);
                    if (_NegativeIndices.length <= i) {
                        Index[] tmp = new Index[_NegativeIndices.length * 2];
                        System.arraycopy(_NegativeIndices, 0, tmp, 0, _NegativeIndices.length);
                        Index.access$402(tmp);
                    }
                    _NegativeIndices[i] = index;
                }
                _NegativeIndicesLength += 32;
            }
        };
        TEXT_FORMAT = new TextFormat(Index.class){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format(((Index)obj).intValue(), dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return Index.valueOf(TypeFormat.parseInt(csq, 10, cursor));
            }
        };
    }
}

