/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class SchemaHookDispatcher
implements SchemaDispatcher {
    private final SchemaDispatcher dispatcher;

    public SchemaHookDispatcher(SchemaDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        return this.dispatcher.listSchemas(namespace);
    }

    @Override
    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        Schema schema = this.dispatcher.createSchema(ident, comment, properties);
        OwnerManager ownerManager = GravitinoEnv.getInstance().ownerManager();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.SCHEMA), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return schema;
    }

    @Override
    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        return this.dispatcher.loadSchema(ident);
    }

    @Override
    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        return this.dispatcher.alterSchema(ident, changes);
    }

    @Override
    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        return this.dispatcher.dropSchema(ident, cascade);
    }

    @Override
    public boolean schemaExists(NameIdentifier ident) {
        return this.dispatcher.schemaExists(ident);
    }
}

