/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.ibatis.annotations.Param;

public class GroupMetaBaseSQLProvider {
    public String selectGroupIdBySchemaIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="groupName") String name) {
        return "SELECT group_id as groupId FROM group_meta WHERE metalake_id = #{metalakeId} AND group_name = #{groupName} AND deleted_at = 0";
    }

    public String listGroupPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return "SELECT gt.group_id as groupId, gt.group_name as groupName, gt.metalake_id as metalakeId, gt.audit_info as auditInfo, gt.current_version as currentVersion, gt.last_version as lastVersion, gt.deleted_at as deletedAt FROM group_meta gt JOIN metalake_meta mt ON gt.metalake_id = mt.metalake_id WHERE mt.metalake_name = #{metalakeName} AND gt.deleted_at = 0 AND mt.deleted_at = 0";
    }

    public String listExtendedGroupPOsByMetalakeId(Long metalakeId) {
        return "SELECT gt.group_id as groupId, gt.group_name as groupName, gt.metalake_id as metalakeId, gt.audit_info as auditInfo, gt.current_version as currentVersion, gt.last_version as lastVersion, gt.deleted_at as deletedAt, JSON_ARRAYAGG(rot.role_name) as roleNames, JSON_ARRAYAGG(rot.role_id) as roleIds FROM group_meta gt LEFT OUTER JOIN group_role_rel rt ON rt.group_id = gt.group_id LEFT OUTER JOIN role_meta rot ON rot.role_id = rt.role_id WHERE  gt.deleted_at = 0 AND (rot.deleted_at = 0 OR rot.deleted_at is NULL) AND (rt.deleted_at = 0 OR rt.deleted_at is NULL) AND gt.metalake_id = #{metalakeId} GROUP BY gt.group_id";
    }

    public String selectGroupMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="groupName") String name) {
        return "SELECT group_id as groupId, group_name as groupName, metalake_id as metalakeId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM group_meta WHERE metalake_id = #{metalakeId} AND group_name = #{groupName} AND deleted_at = 0";
    }

    public String insertGroupMeta(@Param(value="groupMeta") GroupPO groupPO) {
        return "INSERT INTO group_meta(group_id, group_name, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{groupMeta.groupId}, #{groupMeta.groupName}, #{groupMeta.metalakeId}, #{groupMeta.auditInfo}, #{groupMeta.currentVersion}, #{groupMeta.lastVersion}, #{groupMeta.deletedAt} )";
    }

    public String insertGroupMetaOnDuplicateKeyUpdate(@Param(value="groupMeta") GroupPO groupPO) {
        return "INSERT INTO group_meta(group_id, group_name,metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{groupMeta.groupId}, #{groupMeta.groupName}, #{groupMeta.metalakeId}, #{groupMeta.auditInfo}, #{groupMeta.currentVersion}, #{groupMeta.lastVersion}, #{groupMeta.deletedAt} ) ON DUPLICATE KEY UPDATE group_name = #{groupMeta.groupName}, metalake_id = #{groupMeta.metalakeId}, audit_info = #{groupMeta.auditInfo}, current_version = #{groupMeta.currentVersion}, last_version = #{groupMeta.lastVersion}, deleted_at = #{groupMeta.deletedAt}";
    }

    public String softDeleteGroupMetaByGroupId(@Param(value="groupId") Long groupId) {
        return "UPDATE group_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE group_id = #{groupId} AND deleted_at = 0";
    }

    public String softDeleteGroupMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE group_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String updateGroupMeta(@Param(value="newGroupMeta") GroupPO newGroupPO, @Param(value="oldGroupMeta") GroupPO oldGroupPO) {
        return "UPDATE group_meta SET group_name = #{newGroupMeta.groupName}, metalake_id = #{newGroupMeta.metalakeId}, audit_info = #{newGroupMeta.auditInfo}, current_version = #{newGroupMeta.currentVersion}, last_version = #{newGroupMeta.lastVersion}, deleted_at = #{newGroupMeta.deletedAt} WHERE group_id = #{oldGroupMeta.groupId} AND group_name = #{oldGroupMeta.groupName} AND metalake_id = #{oldGroupMeta.metalakeId} AND audit_info = #{oldGroupMeta.auditInfo} AND current_version = #{oldGroupMeta.currentVersion} AND last_version = #{oldGroupMeta.lastVersion} AND deleted_at = 0";
    }

    public String listGroupsByRoleId(@Param(value="roleId") Long roleId) {
        return "SELECT gr.group_id as groupId, gr.group_name as groupName, gr.metalake_id as metalakeId, gr.audit_info as auditInfo, gr.current_version as currentVersion, gr.last_version as lastVersion, gr.deleted_at as deletedAt FROM group_meta gr JOIN group_role_rel re ON gr.group_id = re.group_id WHERE re.role_id = #{roleId} AND gr.deleted_at = 0 AND re.deleted_at = 0";
    }

    public String deleteGroupMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM group_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

