/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.GroupMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.h2.GroupMetaH2Provider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.GroupMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class GroupMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, GroupMetaBaseSQLProvider> GROUP_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new GroupMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new GroupMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new GroupMetaPostgreSQLProvider());

    public static GroupMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return GROUP_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String selectGroupIdBySchemaIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="groupName") String name) {
        return GroupMetaSQLProviderFactory.getProvider().selectGroupIdBySchemaIdAndName(metalakeId, name);
    }

    public static String selectGroupMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="groupName") String name) {
        return GroupMetaSQLProviderFactory.getProvider().selectGroupMetaByMetalakeIdAndName(metalakeId, name);
    }

    public static String insertGroupMeta(@Param(value="groupMeta") GroupPO groupPO) {
        return GroupMetaSQLProviderFactory.getProvider().insertGroupMeta(groupPO);
    }

    public static String insertGroupMetaOnDuplicateKeyUpdate(@Param(value="groupMeta") GroupPO groupPO) {
        return GroupMetaSQLProviderFactory.getProvider().insertGroupMetaOnDuplicateKeyUpdate(groupPO);
    }

    public static String softDeleteGroupMetaByGroupId(@Param(value="groupId") Long groupId) {
        return GroupMetaSQLProviderFactory.getProvider().softDeleteGroupMetaByGroupId(groupId);
    }

    public static String softDeleteGroupMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return GroupMetaSQLProviderFactory.getProvider().softDeleteGroupMetasByMetalakeId(metalakeId);
    }

    public static String updateGroupMeta(@Param(value="newGroupMeta") GroupPO newGroupPO, @Param(value="oldGroupMeta") GroupPO oldGroupPO) {
        return GroupMetaSQLProviderFactory.getProvider().updateGroupMeta(newGroupPO, oldGroupPO);
    }

    public static String listGroupsByRoleId(@Param(value="roleId") Long roleId) {
        return GroupMetaSQLProviderFactory.getProvider().listGroupsByRoleId(roleId);
    }

    public static String listGroupPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return GroupMetaSQLProviderFactory.getProvider().listGroupPOsByMetalake(metalakeName);
    }

    public static String listExtendedGroupPOsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return GroupMetaSQLProviderFactory.getProvider().listExtendedGroupPOsByMetalakeId(metalakeId);
    }

    public static String deleteGroupMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return GroupMetaSQLProviderFactory.getProvider().deleteGroupMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class GroupMetaMySQLProvider
    extends GroupMetaBaseSQLProvider {
        GroupMetaMySQLProvider() {
        }
    }
}

