/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.Action;

abstract class BaseAction<ThisT, R>
implements Action<ThisT, R> {
    BaseAction() {
    }

    protected abstract Table table();

    protected String metadataTableName(MetadataTableType type) {
        return this.metadataTableName(this.table().name(), type);
    }

    protected String metadataTableName(String tableName, MetadataTableType type) {
        if (tableName.contains("/")) {
            return tableName + "#" + (Object)((Object)type);
        }
        if (tableName.startsWith("hadoop.")) {
            return this.table().location() + "#" + (Object)((Object)type);
        }
        if (tableName.startsWith("hive.")) {
            return tableName.replaceFirst("hive\\.", "") + "." + (Object)((Object)type);
        }
        return tableName + "." + (Object)((Object)type);
    }
}

