/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.expressions.Aggregate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.CountNonNull;
import org.apache.iceberg.expressions.CountStar;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.MaxAggregate;
import org.apache.iceberg.expressions.MinAggregate;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Unbound;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Types;

public class UnboundAggregate<T>
extends Aggregate<UnboundTerm<T>>
implements Unbound<T, Expression> {
    UnboundAggregate(Expression.Operation op, UnboundTerm<T> term) {
        super(op, term);
    }

    @Override
    public NamedReference<?> ref() {
        return ((UnboundTerm)this.term()).ref();
    }

    @Override
    public Expression bind(Types.StructType struct, boolean caseSensitive) {
        switch (this.op()) {
            case COUNT_STAR: {
                return new CountStar(null);
            }
            case COUNT: {
                return new CountNonNull<T>(this.boundTerm(struct, caseSensitive));
            }
            case MAX: {
                return new MaxAggregate<T>(this.boundTerm(struct, caseSensitive));
            }
            case MIN: {
                return new MinAggregate<T>(this.boundTerm(struct, caseSensitive));
            }
        }
        throw new UnsupportedOperationException("Unsupported aggregate type: " + (Object)((Object)this.op()));
    }

    private BoundTerm<T> boundTerm(Types.StructType struct, boolean caseSensitive) {
        Preconditions.checkArgument((this.term() != null ? 1 : 0) != 0, (Object)"Invalid aggregate term: null");
        return (BoundTerm)((UnboundTerm)this.term()).bind(struct, caseSensitive);
    }
}

