/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.ConnectionHolder;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.Wrapped;
import java.util.Optional;

public class ProxyUtils {
    private ProxyUtils() {
    }

    public static Optional<Connection> unwrapConnection(Connection connection) {
        Assert.requireNonNull(connection, "connection must not be null");
        if (connection instanceof Wrapped) {
            return Optional.of(((Wrapped)connection).unwrap());
        }
        return Optional.of(connection);
    }

    public static Optional<Connection> unwrapConnection(Batch batch) {
        Assert.requireNonNull(batch, "batch must not be null");
        if (batch instanceof ConnectionHolder) {
            return Optional.of(((ConnectionHolder)batch).unwrapConnection());
        }
        return Optional.empty();
    }

    public static Optional<Connection> unwrapConnection(Statement statement) {
        Assert.requireNonNull(statement, "statement must not be null");
        if (statement instanceof ConnectionHolder) {
            return Optional.of(((ConnectionHolder)statement).unwrapConnection());
        }
        return Optional.empty();
    }

    public static Optional<Connection> unwrapConnection(Result result) {
        Assert.requireNonNull(result, "result must not be null");
        if (result instanceof ConnectionHolder) {
            return Optional.of(((ConnectionHolder)result).unwrapConnection());
        }
        return Optional.empty();
    }
}

