/*
 * Decompiled with CFR 0.152.
 */
package com.obs.log;

import com.obs.log.AbstractLog4jLogger;
import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.log.LoggerMethodHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class Log4j2Logger
extends AbstractLog4jLogger
implements ILogger {
    private static final Logger ILOG = Logger.getLogger(Log4j2Logger.class.getName());
    private volatile int isInfoE = -1;
    private volatile int isDebugE = -1;
    private volatile int isErrorE = -1;
    private volatile int isWarnE = -1;
    private volatile int isTraceE = -1;

    Log4j2Logger(Object logger) {
        super(logger);
    }

    @Override
    public boolean isInfoEnabled() {
        if (this.isInfoE == -1) {
            try {
                this.isInfoE = this.logger != null && Log4j2LoggerMethodHolder.isInfo != null && (Boolean)Log4j2LoggerMethodHolder.isInfo.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.isInfoE = 0;
            }
        }
        return this.isInfoE == 1;
    }

    @Override
    public boolean isWarnEnabled() {
        if (this.isWarnE == -1) {
            try {
                this.isWarnE = this.logger != null && Log4j2LoggerMethodHolder.isWarn != null && (Boolean)Log4j2LoggerMethodHolder.isWarn.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.isWarnE = 0;
            }
        }
        return this.isWarnE == 1;
    }

    @Override
    public boolean isErrorEnabled() {
        if (this.isErrorE == -1) {
            try {
                this.isErrorE = this.logger != null && Log4j2LoggerMethodHolder.isError != null && (Boolean)Log4j2LoggerMethodHolder.isError.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.isErrorE = 0;
            }
        }
        return this.isErrorE == 1;
    }

    @Override
    public boolean isDebugEnabled() {
        if (this.isDebugE == -1) {
            try {
                this.isDebugE = this.logger != null && Log4j2LoggerMethodHolder.isDebug != null && (Boolean)Log4j2LoggerMethodHolder.isDebug.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.isDebugE = 0;
            }
        }
        return this.isDebugE == 1;
    }

    @Override
    public boolean isTraceEnabled() {
        if (this.isTraceE == -1) {
            try {
                this.isTraceE = this.logger != null && Log4j2LoggerMethodHolder.isTrace != null && (Boolean)Log4j2LoggerMethodHolder.isTrace.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.isTraceE = 0;
            }
        }
        return this.isTraceE == 1;
    }

    private static class Log4j2LoggerMethodHolder
    extends LoggerMethodHolder {
        private static Method isInfo;
        private static Method isDebug;
        private static Method isError;
        private static Method isWarn;
        private static Method isTrace;

        private Log4j2LoggerMethodHolder() {
        }

        static {
            try {
                if (LoggerBuilder.GetLoggerHolder.loggerClass != null) {
                    isInfo = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isInfoEnabled", new Class[0]);
                    isDebug = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isDebugEnabled", new Class[0]);
                    isError = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isErrorEnabled", new Class[0]);
                    isWarn = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isWarnEnabled", new Class[0]);
                    isTrace = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isTraceEnabled", new Class[0]);
                }
            }
            catch (NoSuchMethodException | SecurityException e) {
                ILOG.warning(e.getMessage());
            }
        }
    }
}

