/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.model.ProgressListener;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MonitorableProgressListener
implements ProgressListener {
    private static final ILogger ILOG = LoggerBuilder.getLogger(MonitorableProgressListener.class);
    private AtomicInteger runningTask = new AtomicInteger(1);

    public final boolean isRunning() {
        return this.runningTask.get() > 0;
    }

    public final boolean waitingFinish() throws InterruptedException {
        return this.waitingFinish(-1L);
    }

    public final boolean waitingFinish(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        if (ILOG.isDebugEnabled()) {
            ILOG.debug("this.runningTask = " + this.runningTask);
        }
        while (this.runningTask.get() > 0) {
            if (System.currentTimeMillis() - start > timeout && timeout > 0L) {
                if (ILOG.isWarnEnabled()) {
                    ILOG.warn("DownloadFileReqeust is not finish. " + this.toString());
                }
                return false;
            }
            Thread.sleep(100L);
        }
        return true;
    }

    public final void startOneTask() {
        this.runningTask.incrementAndGet();
    }

    public final void finishOneTask() {
        this.runningTask.decrementAndGet();
    }

    public final void reset() {
        this.runningTask.set(1);
    }
}

