/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import io.greptime.common.util.Ensures;
import io.greptime.common.util.ObjectPool;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcResourceHolder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RcResourceHolder.class);
    private final Map<ObjectPool.Resource<T>, Instance<T>> instances = new IdentityHashMap<ObjectPool.Resource<T>, Instance<T>>();

    public synchronized T get(ObjectPool.Resource<T> resource) {
        Instance<T> ins = this.instances.get(resource);
        if (ins == null) {
            ins = new Instance<T>(resource.create());
            this.instances.put(resource, ins);
            LOG.info("[RcResourceHolder] create instance: {}.", ins);
        }
        ins.inc();
        return ins.payload();
    }

    public synchronized void release(ObjectPool.Resource<T> resource, T returned) {
        Instance<T> cached = this.instances.get(resource);
        Ensures.ensureNonNull(cached, "No cached instance found for " + resource);
        Ensures.ensure(returned == cached.payload(), "Releasing the wrong instance, expected=%s, actual=%s", cached.payload(), returned);
        Ensures.ensure(cached.rc() > 0, "RefCount has already reached zero");
        if (cached.decAndGet() == 0) {
            LOG.info("[RcResourceHolder] close instance: {}.", cached);
            resource.close(cached.payload());
            this.instances.remove(resource);
        }
    }

    private static class Instance<T> {
        final T payload;
        int refCount;
        int maxRefCount;

        Instance(T payload) {
            this.payload = payload;
        }

        void inc() {
            ++this.refCount;
            this.maxRefCount = Math.max(this.maxRefCount, this.refCount);
        }

        int decAndGet() {
            return --this.refCount;
        }

        int rc() {
            return this.refCount;
        }

        T payload() {
            return this.payload;
        }

        public String toString() {
            return "Instance{payload=" + this.payload + ", refCount=" + this.refCount + ", maxRefCount=" + this.maxRefCount + '}';
        }
    }
}

