/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.stereotype.Component;

@Converter
@Component
public class JsonMapListAttributeConverter
implements AttributeConverter<Map<String, List<String>>, String> {
    public String convertToDatabaseColumn(Map<String, List<String>> attribute) {
        return JsonUtil.toJson(attribute);
    }

    public Map<String, List<String>> convertToEntityAttribute(String dbData) {
        TypeReference<Map<String, List<String>>> typeReference = new TypeReference<Map<String, List<String>>>(){};
        return JsonUtil.fromJson(dbData, typeReference);
    }
}

