/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.hertzbeat.common.entity.manager.Collector;

@Schema(description="collector summary")
public class CollectorSummary {
    @Schema(description="the collector info")
    private Collector collector;
    @Schema(description="the number of monitors pinned in this collector")
    private int pinMonitorNum;
    @Schema(description="the number of monitors dispatched in this collector")
    private int dispatchMonitorNum;

    public static CollectorSummaryBuilder builder() {
        return new CollectorSummaryBuilder();
    }

    public Collector getCollector() {
        return this.collector;
    }

    public int getPinMonitorNum() {
        return this.pinMonitorNum;
    }

    public int getDispatchMonitorNum() {
        return this.dispatchMonitorNum;
    }

    public void setCollector(Collector collector) {
        this.collector = collector;
    }

    public void setPinMonitorNum(int pinMonitorNum) {
        this.pinMonitorNum = pinMonitorNum;
    }

    public void setDispatchMonitorNum(int dispatchMonitorNum) {
        this.dispatchMonitorNum = dispatchMonitorNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectorSummary)) {
            return false;
        }
        CollectorSummary other = (CollectorSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPinMonitorNum() != other.getPinMonitorNum()) {
            return false;
        }
        if (this.getDispatchMonitorNum() != other.getDispatchMonitorNum()) {
            return false;
        }
        Collector this$collector = this.getCollector();
        Collector other$collector = other.getCollector();
        return !(this$collector == null ? other$collector != null : !((Object)this$collector).equals(other$collector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectorSummary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPinMonitorNum();
        result = result * 59 + this.getDispatchMonitorNum();
        Collector $collector = this.getCollector();
        result = result * 59 + ($collector == null ? 43 : ((Object)$collector).hashCode());
        return result;
    }

    public String toString() {
        return "CollectorSummary(collector=" + this.getCollector() + ", pinMonitorNum=" + this.getPinMonitorNum() + ", dispatchMonitorNum=" + this.getDispatchMonitorNum() + ")";
    }

    public CollectorSummary(Collector collector, int pinMonitorNum, int dispatchMonitorNum) {
        this.collector = collector;
        this.pinMonitorNum = pinMonitorNum;
        this.dispatchMonitorNum = dispatchMonitorNum;
    }

    public CollectorSummary() {
    }

    public static class CollectorSummaryBuilder {
        private Collector collector;
        private int pinMonitorNum;
        private int dispatchMonitorNum;

        CollectorSummaryBuilder() {
        }

        public CollectorSummaryBuilder collector(Collector collector) {
            this.collector = collector;
            return this;
        }

        public CollectorSummaryBuilder pinMonitorNum(int pinMonitorNum) {
            this.pinMonitorNum = pinMonitorNum;
            return this;
        }

        public CollectorSummaryBuilder dispatchMonitorNum(int dispatchMonitorNum) {
            this.dispatchMonitorNum = dispatchMonitorNum;
            return this;
        }

        public CollectorSummary build() {
            return new CollectorSummary(this.collector, this.pinMonitorNum, this.dispatchMonitorNum);
        }

        public String toString() {
            return "CollectorSummary.CollectorSummaryBuilder(collector=" + this.collector + ", pinMonitorNum=" + this.pinMonitorNum + ", dispatchMonitorNum=" + this.dispatchMonitorNum + ")";
        }
    }
}

