/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.encryption.handler;

import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.plugin.encryption.EncryptionPluginManager;
import com.alibaba.nacos.plugin.encryption.spi.EncryptionPluginService;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionHandler.class);
    private static final String PREFIX = "cipher-";

    public static Pair<String, String> encryptHandler(String dataId, String content) {
        if (!EncryptionHandler.checkCipher(dataId)) {
            return Pair.with((Object)"", (Object)content);
        }
        Optional<String> algorithmName = EncryptionHandler.parseAlgorithmName(dataId);
        Optional optional = algorithmName.flatMap(EncryptionPluginManager.instance()::findEncryptionService);
        if (!optional.isPresent()) {
            LOGGER.warn("[EncryptionHandler] [encryptHandler] No encryption program with the corresponding name found");
            return Pair.with((Object)"", (Object)content);
        }
        EncryptionPluginService encryptionPluginService = (EncryptionPluginService)optional.get();
        String secretKey = encryptionPluginService.generateSecretKey();
        String encryptContent = encryptionPluginService.encrypt(secretKey, content);
        return Pair.with((Object)encryptionPluginService.encryptSecretKey(secretKey), (Object)encryptContent);
    }

    public static Pair<String, String> decryptHandler(String dataId, String secretKey, String content) {
        if (!EncryptionHandler.checkCipher(dataId)) {
            return Pair.with((Object)"", (Object)content);
        }
        Optional<String> algorithmName = EncryptionHandler.parseAlgorithmName(dataId);
        Optional optional = algorithmName.flatMap(EncryptionPluginManager.instance()::findEncryptionService);
        if (!optional.isPresent()) {
            LOGGER.warn("[EncryptionHandler] [decryptHandler] No encryption program with the corresponding name found");
            return Pair.with((Object)"", (Object)content);
        }
        EncryptionPluginService encryptionPluginService = (EncryptionPluginService)optional.get();
        String decryptSecretKey = encryptionPluginService.decryptSecretKey(secretKey);
        String decryptContent = encryptionPluginService.decrypt(decryptSecretKey, content);
        return Pair.with((Object)decryptSecretKey, (Object)decryptContent);
    }

    private static Optional<String> parseAlgorithmName(String dataId) {
        return Stream.of(dataId.split("-")).skip(1L).findFirst();
    }

    private static boolean checkCipher(String dataId) {
        return dataId.startsWith(PREFIX) && !PREFIX.equals(dataId);
    }
}

