/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.convert;

import dm.jdbc.convert.OffRowData;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteArrayQueue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class OffRowInputStreamData
extends OffRowData {
    public OffRowInputStreamData(InputStream inputStream, Charset charset, long l2) {
        super(inputStream, charset, l2);
    }

    @Override
    public void read(ByteArrayQueue byteArrayQueue) {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArrayQueue);
        } else if (!this.readOver) {
            int n2 = READ_LEN;
            if (this.targetLength != -1L) {
                n2 = (int)(this.targetLength - (long)this.position > (long)n2 ? (long)n2 : this.targetLength - (long)this.position);
            }
            try {
                InputStream inputStream = (InputStream)this.obj;
                byte[] byArray = new byte[n2];
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    n3 = inputStream.read(byArray, n4, n2 - n4);
                    if (n3 <= 0) {
                        this.readOver = true;
                        break;
                    }
                    n4 += n3;
                }
                n2 = n4;
                this.position += n2;
                if (n2 < byArray.length || this.targetLength != -1L && (long)this.position == this.targetLength) {
                    this.readOver = true;
                }
                byteArrayQueue.putBytes(byArray, 0, n2);
            }
            catch (IOException iOException) {
                DBError.throwException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public byte[] readAll() {
        ByteArrayQueue byteArrayQueue = new ByteArrayQueue();
        this.read(byteArrayQueue);
        while (!this.readOver) {
            this.read(byteArrayQueue);
        }
        return byteArrayQueue.toBytes();
    }
}

