/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum MessageStatusCode implements IpmiCode.Code
{
    NO_ERRORS(0, "No errors"),
    INSUFFICIENT_RESOURCE(1, "Insufficient resources to create a session"),
    INVALID_SESSION_ID(2, "Invalid session ID"),
    INVALID_PAYLOAD_TYPE(3, "Invalid payload type"),
    INVALID_AUTHENTICATION_ALGORITHM(4, "Invalid authentication algorithm"),
    INVALID_INTEGRITY_ALGORITHM(5, "Invalid integrity algorithm"),
    NO_MATCHING_AUTHENTICATION(6, "No matching authentication payload"),
    NO_MATCHING_INTEGRITY(7, "No matching integrity payload"),
    INACTIVE_SESSION(8, "Inactive session ID"),
    INVALID_ROLE(9, "Invalid role"),
    UNAUTHORIZED_ROLE(10, "No matching authentication payload"),
    INSUFFICIENT_RESOURCE_FOR_ROLE(11, "Insufficient resources to create asession at the requested role"),
    INVALID_NAME(12, "Invalid name length"),
    UNAUTHORIZED_NAME(13, "Unauthorized name"),
    UNAUTHORIZED_GUID(14, "Unauthorized GUID. (GUID that BMCsubmitted in RAKP Message 2 was notaccepted by remote console)"),
    INVALID_INTEGRITY_CHECK_VALUE(15, "Invalid integrity check value"),
    INVALID_CONFIDENTIALITY_ALGORITHM(16, "Invalid confidentiality algorithm"),
    NO_CIPHER_SUITE_MATCH(17, "No Cipher Suite match with proposed security algorithms"),
    ILLEGAL_PARAMETER(18, "Illegal or unrecognized parameter");

    public static final int MASK = 255;
    private final byte code;
    private final String description;

    private MessageStatusCode(int code, String description) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.description = description;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

