/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

public class PlcLTIME_OF_DAY
extends PlcSimpleValue<LocalTime> {
    public static PlcLTIME_OF_DAY of(Object value) {
        if (value instanceof LocalTime) {
            return new PlcLTIME_OF_DAY((LocalTime)value);
        }
        if (value instanceof Long) {
            return new PlcLTIME_OF_DAY(LocalTime.ofSecondOfDay((Long)value / 1000L));
        }
        if (value instanceof BigInteger) {
            return new PlcLTIME_OF_DAY(LocalTime.ofSecondOfDay(((BigInteger)value).longValue() / 1000L));
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    public static PlcLTIME_OF_DAY ofNanosecondsSinceMidnight(BigInteger nanosecondsSinceMidnight) {
        return new PlcLTIME_OF_DAY(LocalTime.ofNanoOfDay(nanosecondsSinceMidnight.longValue()));
    }

    public PlcLTIME_OF_DAY(LocalTime value) {
        super(value, true);
    }

    public PlcLTIME_OF_DAY(Long nanosecondsSinceMidnight) {
        super(LocalTime.ofNanoOfDay(nanosecondsSinceMidnight), true);
    }

    public PlcLTIME_OF_DAY(BigInteger nanosecondsSinceMidnight) {
        super(LocalTime.ofNanoOfDay(nanosecondsSinceMidnight.longValue()), true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.LTIME_OF_DAY;
    }

    public BigInteger getNanosecondsSinceMidnight() {
        return BigInteger.valueOf(((LocalTime)this.value).toSecondOfDay()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(((LocalTime)this.value).getNano()));
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return (long)((LocalTime)this.value).toSecondOfDay() * 1000L;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalTime)this.value).toString();
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public LocalTime getTime() {
        return (LocalTime)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

