/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.config;

import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseLinkCustomizer
implements SessionCustomizer {
    private static final Logger log = LoggerFactory.getLogger(EclipseLinkCustomizer.class);

    public void customize(Session session) throws Exception {
        for (ClassDescriptor descriptor : session.getDescriptors().values()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!mapping.isDirectToFieldMapping() || !mapping.getField().getName().equalsIgnoreCase(mapping.getAttributeName())) continue;
                mapping.getField().setName(this.convertCamelCase(mapping.getAttributeName()));
            }
        }
    }

    private String convertCamelCase(String camelCase) {
        StringBuilder result = new StringBuilder();
        if (camelCase != null && !camelCase.isEmpty()) {
            result.append(Character.toLowerCase(camelCase.charAt(0)));
            for (int i = 1; i < camelCase.length(); ++i) {
                char currentChar = camelCase.charAt(i);
                if (Character.isUpperCase(currentChar)) {
                    result.append('_').append(Character.toLowerCase(currentChar));
                    continue;
                }
                result.append(currentChar);
            }
        }
        return result.toString();
    }
}

