/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.DirInfo;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.HostRole;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ServiceInfo
implements TBase,
Serializable,
Cloneable,
Comparable<ServiceInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("ServiceInfo");
    private static final TField DIR_FIELD_DESC = new TField("dir", 12, 1);
    private static final TField ADDR_FIELD_DESC = new TField("addr", 12, 2);
    private static final TField ROLE_FIELD_DESC = new TField("role", 8, 3);
    public DirInfo dir;
    public HostAddr addr;
    public HostRole role;
    public static final int DIR = 1;
    public static final int ADDR = 2;
    public static final int ROLE = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ServiceInfo() {
    }

    public ServiceInfo(DirInfo dir, HostAddr addr, HostRole role) {
        this();
        this.dir = dir;
        this.addr = addr;
        this.role = role;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServiceInfo(ServiceInfo other) {
        if (other.isSetDir()) {
            this.dir = TBaseHelper.deepCopy(other.dir);
        }
        if (other.isSetAddr()) {
            this.addr = TBaseHelper.deepCopy(other.addr);
        }
        if (other.isSetRole()) {
            this.role = TBaseHelper.deepCopy(other.role);
        }
    }

    @Override
    public ServiceInfo deepCopy() {
        return new ServiceInfo(this);
    }

    public DirInfo getDir() {
        return this.dir;
    }

    public ServiceInfo setDir(DirInfo dir) {
        this.dir = dir;
        return this;
    }

    public void unsetDir() {
        this.dir = null;
    }

    public boolean isSetDir() {
        return this.dir != null;
    }

    public void setDirIsSet(boolean __value) {
        if (!__value) {
            this.dir = null;
        }
    }

    public HostAddr getAddr() {
        return this.addr;
    }

    public ServiceInfo setAddr(HostAddr addr) {
        this.addr = addr;
        return this;
    }

    public void unsetAddr() {
        this.addr = null;
    }

    public boolean isSetAddr() {
        return this.addr != null;
    }

    public void setAddrIsSet(boolean __value) {
        if (!__value) {
            this.addr = null;
        }
    }

    public HostRole getRole() {
        return this.role;
    }

    public ServiceInfo setRole(HostRole role) {
        this.role = role;
        return this;
    }

    public void unsetRole() {
        this.role = null;
    }

    public boolean isSetRole() {
        return this.role != null;
    }

    public void setRoleIsSet(boolean __value) {
        if (!__value) {
            this.role = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetDir();
                    break;
                }
                this.setDir((DirInfo)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetAddr();
                    break;
                }
                this.setAddr((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetRole();
                    break;
                }
                this.setRole((HostRole)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getDir();
            }
            case 2: {
                return this.getAddr();
            }
            case 3: {
                return this.getRole();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo that = (ServiceInfo)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetDir(), that.isSetDir(), this.dir, that.dir)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetAddr(), that.isSetAddr(), this.addr, that.addr)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetRole(), that.isSetRole(), this.role, that.role);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.dir, this.addr, this.role});
    }

    @Override
    public int compareTo(ServiceInfo other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetDir()).compareTo(other.isSetDir());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.dir, other.dir);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAddr()).compareTo(other.isSetAddr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.addr, other.addr);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRole()).compareTo(other.isSetRole());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.role, other.role);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.dir = new DirInfo();
                        this.dir.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.addr = new HostAddr();
                        this.addr.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 8) {
                        this.role = HostRole.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.dir != null) {
            oprot.writeFieldBegin(DIR_FIELD_DESC);
            this.dir.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.addr != null) {
            oprot.writeFieldBegin(ADDR_FIELD_DESC);
            this.addr.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.role != null) {
            oprot.writeFieldBegin(ROLE_FIELD_DESC);
            oprot.writeI32(this.role == null ? 0 : this.role.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ServiceInfo");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("dir");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getDir() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getDir(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("addr");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getAddr() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getAddr(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("role");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getRole() == null) {
            sb.append("null");
        } else {
            String role_name;
            String string = role_name = this.getRole() == null ? "null" : this.getRole().name();
            if (role_name != null) {
                sb.append(role_name);
                sb.append(" (");
            }
            sb.append(this.getRole());
            if (role_name != null) {
                sb.append(")");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("dir", 3, new StructMetaData(12, DirInfo.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("addr", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("role", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ServiceInfo.class, metaDataMap);
    }

    public static class Builder {
        private DirInfo dir;
        private HostAddr addr;
        private HostRole role;

        public Builder setDir(DirInfo dir) {
            this.dir = dir;
            return this;
        }

        public Builder setAddr(HostAddr addr) {
            this.addr = addr;
            return this;
        }

        public Builder setRole(HostRole role) {
            this.role = role;
            return this;
        }

        public ServiceInfo build() {
            ServiceInfo result = new ServiceInfo();
            result.setDir(this.dir);
            result.setAddr(this.addr);
            result.setRole(this.role);
            return result;
        }
    }
}

