/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.kryo.kryo.serializers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.livy.shaded.kryo.kryo.Serializer;
import org.apache.livy.shaded.kryo.kryo.factories.ReflectionSerializerFactory;
import org.apache.livy.shaded.kryo.kryo.serializers.CollectionSerializer;
import org.apache.livy.shaded.kryo.kryo.serializers.FieldSerializer;
import org.apache.livy.shaded.kryo.kryo.serializers.MapSerializer;

final class FieldSerializerAnnotationsUtil {
    public FieldSerializerAnnotationsUtil(FieldSerializer serializer) {
    }

    public void processAnnotatedFields(FieldSerializer fieldSerializer) {
        FieldSerializer.CachedField[] fields = fieldSerializer.getFields();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            Annotation annotation2;
            Field field = fields[i].getField();
            if (field.isAnnotationPresent(FieldSerializer.Bind.class)) {
                Class<? extends Serializer> serializerClass = field.getAnnotation(FieldSerializer.Bind.class).value();
                Serializer s = ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), serializerClass, field.getClass());
                fields[i].setSerializer(s);
            }
            if (!field.isAnnotationPresent(CollectionSerializer.BindCollection.class) || field.isAnnotationPresent(MapSerializer.BindMap.class)) {
                // empty if block
            }
            if (field.isAnnotationPresent(CollectionSerializer.BindCollection.class)) {
                if (fields[i].serializer != null) {
                    throw new RuntimeException("CollectionSerialier.Bind cannot be used with field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + ", because it has a serializer already.");
                }
                annotation2 = field.getAnnotation(CollectionSerializer.BindCollection.class);
                if (Collection.class.isAssignableFrom(fields[i].field.getType())) {
                    Class<? extends Serializer> elementSerializerClass = annotation2.elementSerializer();
                    if (elementSerializerClass == Serializer.class) {
                        elementSerializerClass = null;
                    }
                    Serializer elementSerializer = elementSerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), elementSerializerClass, field.getClass());
                    boolean elementsCanBeNull = annotation2.elementsCanBeNull();
                    Class<?> elementClass = annotation2.elementClass();
                    if (elementClass == Object.class) {
                        elementClass = null;
                    }
                    CollectionSerializer serializer = new CollectionSerializer();
                    serializer.setElementsCanBeNull(elementsCanBeNull);
                    serializer.setElementClass(elementClass, elementSerializer);
                    fields[i].setSerializer(serializer);
                } else {
                    throw new RuntimeException("CollectionSerialier.Bind should be used only with fields implementing java.util.Collection, but field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + " does not implement it.");
                }
            }
            if (!field.isAnnotationPresent(MapSerializer.BindMap.class)) continue;
            if (fields[i].serializer != null) {
                throw new RuntimeException("MapSerialier.Bind cannot be used with field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + ", because it has a serializer already.");
            }
            annotation2 = field.getAnnotation(MapSerializer.BindMap.class);
            if (Map.class.isAssignableFrom(fields[i].field.getType())) {
                Class<? extends Serializer> valueSerializerClass = annotation2.valueSerializer();
                Class<? extends Serializer> keySerializerClass = annotation2.keySerializer();
                if (valueSerializerClass == Serializer.class) {
                    valueSerializerClass = null;
                }
                if (keySerializerClass == Serializer.class) {
                    keySerializerClass = null;
                }
                Serializer valueSerializer = valueSerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), valueSerializerClass, field.getClass());
                Serializer keySerializer = keySerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), keySerializerClass, field.getClass());
                boolean valuesCanBeNull = annotation2.valuesCanBeNull();
                boolean keysCanBeNull = annotation2.keysCanBeNull();
                Class<?> keyClass = annotation2.keyClass();
                Class<?> valueClass = annotation2.valueClass();
                if (keyClass == Object.class) {
                    keyClass = null;
                }
                if (valueClass == Object.class) {
                    valueClass = null;
                }
                MapSerializer serializer = new MapSerializer();
                serializer.setKeysCanBeNull(keysCanBeNull);
                serializer.setValuesCanBeNull(valuesCanBeNull);
                serializer.setKeyClass(keyClass, keySerializer);
                serializer.setValueClass(valueClass, valueSerializer);
                fields[i].setSerializer(serializer);
                continue;
            }
            throw new RuntimeException("MapSerialier.Bind should be used only with fields implementing java.util.Map, but field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + " does not implement it.");
        }
    }
}

