/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.lang.Nullable;

public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    @Nullable
    private final PropertySources propertySources;

    public PropertySourcesPropertyResolver(@Nullable PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                if (!propertySource.containsProperty(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        return this.getProperty(key, String.class, true);
    }

    @Override
    @Nullable
    public <T> T getProperty(String key, Class<T> targetValueType) {
        return this.getProperty(key, targetValueType, true);
    }

    @Override
    @Nullable
    protected String getPropertyAsRawString(String key) {
        return this.getProperty(key, String.class, false);
    }

    @Nullable
    protected <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Object value2;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Searching for key '" + key + "' in PropertySource '" + propertySource.getName() + "'");
                }
                if ((value2 = propertySource.getProperty(key)) == null) continue;
                if (resolveNestedPlaceholders && value2 instanceof String) {
                    value2 = this.resolveNestedPlaceholders((String)value2);
                }
                this.logKeyFound(key, propertySource, value2);
                return this.convertValueIfNecessary(value2, targetValueType);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Could not find key '" + key + "' in any property source");
        }
        return null;
    }

    protected void logKeyFound(String key, PropertySource<?> propertySource, Object value2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found key '" + key + "' in PropertySource '" + propertySource.getName() + "' with value of type " + value2.getClass().getSimpleName());
        }
    }
}

