/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ReportConstraint;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.engine.constraint.SparqlValidation;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class ConstraintComponentSPARQL
implements Constraint {
    protected final SparqlComponent sparqlConstraintComponent;
    protected final MultiValuedMap<Parameter, Node> parameterMap;
    protected final Query query;

    public ConstraintComponentSPARQL(SparqlComponent sparqlConstraintComponent, MultiValuedMap<Parameter, Node> parameterMap) {
        this.sparqlConstraintComponent = sparqlConstraintComponent;
        this.parameterMap = parameterMap;
        this.query = sparqlConstraintComponent.getQuery();
        if (!this.query.isAskType() && !this.query.isSelectType()) {
            throw new ShaclParseException("Not a SELECT or ASK query");
        }
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        SparqlValidation.validate(vCxt, data, shape, focusNode, null, focusNode, this.query, this.parameterMap, this.sparqlConstraintComponent.getMessage(), new ReportConstraint(this.sparqlConstraintComponent.getReportComponent()));
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> valueNodes) {
        valueNodes.forEach(vn -> SparqlValidation.validate(vCxt, data, shape, focusNode, path, vn, this.query, this.parameterMap, this.sparqlConstraintComponent.getMessage(), new ReportConstraint(this.sparqlConstraintComponent.getReportComponent())));
    }

    @Override
    public Node getComponent() {
        return SHACL.SPARQLConstraintComponent;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
    }

    public String toString() {
        if (this.sparqlConstraintComponent.getQuery().isSelectType()) {
            return "SELECT" + String.valueOf(this.parameterMap);
        }
        return "ASK" + String.valueOf(this.parameterMap);
    }

    public int hashCode() {
        return Objects.hash(this.parameterMap, this.sparqlConstraintComponent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintComponentSPARQL other = (ConstraintComponentSPARQL)obj;
        return Objects.equals(this.parameterMap, other.parameterMap) && Objects.equals(this.sparqlConstraintComponent, other.sparqlConstraintComponent);
    }
}

