/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentIdMgr {
    private static Logger log = LoggerFactory.getLogger(ComponentIdMgr.class);
    private static Map<String, Integer> names = new HashMap<String, Integer>();
    private Map<String, ComponentId> allocated = new HashMap<String, ComponentId>();
    static Map<String, String> mapper;
    private final UUID base;

    static void setup(int idx, String unitName) {
        if (names.containsKey(unitName)) {
            log.error("Name '" + unitName + "' is already registered");
        }
        names.put(unitName, idx);
    }

    public ComponentIdMgr(UUID base) {
        this.base = base;
    }

    public static int getIndex(String name) {
        Integer idx = names.get(name);
        if (idx == null) {
            log.error("Unregistered '" + name + "'");
            return -1;
        }
        return idx;
    }

    public ComponentId getComponentId(String name) {
        if (!names.containsKey(name)) {
            log.error("Name '" + name + "' is not registered");
        }
        if (this.allocated.containsKey(name)) {
            log.error("ComponentId for '" + name + "' has already been allocated");
            return this.allocated.get(name);
        }
        ComponentId cid = ComponentId.alloc(name, this.base, names.get(name));
        this.allocated.put(name, cid);
        return cid;
    }

    static {
        ComponentIdMgr.setup(1, "SPO");
        ComponentIdMgr.setup(2, "POS");
        ComponentIdMgr.setup(3, "PSO");
        ComponentIdMgr.setup(4, "OSP");
        ComponentIdMgr.setup(11, "GSPO");
        ComponentIdMgr.setup(12, "GPOS");
        ComponentIdMgr.setup(13, "GPSO");
        ComponentIdMgr.setup(14, "GOSP");
        ComponentIdMgr.setup(21, "POSG");
        ComponentIdMgr.setup(22, "PSOG");
        ComponentIdMgr.setup(23, "OSPG");
        ComponentIdMgr.setup(24, "SPOG");
        ComponentIdMgr.setup(30, "GPU");
        ComponentIdMgr.setup(40, "prefixes");
        ComponentIdMgr.setup(41, "prefixes-data");
        ComponentIdMgr.setup(50, "nodes");
        ComponentIdMgr.setup(51, "nodes-data");
        mapper = new HashMap<String, String>();
    }
}

