/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.util.function.Function;
import javax.json.bind.config.PropertyNamingStrategy;

public class PropertyNamingStrategyFactory {
    private final Object value;

    public PropertyNamingStrategyFactory(Object value) {
        this.value = value;
    }

    public PropertyNamingStrategy create() {
        if (String.class.isInstance(this.value)) {
            String val;
            switch (val = this.value.toString()) {
                case "IDENTITY": {
                    return propertyName -> propertyName;
                }
                case "LOWER_CASE_WITH_DASHES": {
                    return new ConfigurableNamingStrategy(Character::toLowerCase, '-');
                }
                case "LOWER_CASE_WITH_UNDERSCORES": {
                    return new ConfigurableNamingStrategy(Character::toLowerCase, '_');
                }
                case "UPPER_CAMEL_CASE": {
                    return this.camelCaseStrategy();
                }
                case "UPPER_CAMEL_CASE_WITH_SPACES": {
                    PropertyNamingStrategy camelCase = this.camelCaseStrategy();
                    ConfigurableNamingStrategy space = new ConfigurableNamingStrategy(Function.identity(), ' ');
                    return propertyName -> camelCase.translateName(space.translateName(propertyName));
                }
                case "CASE_INSENSITIVE": {
                    return propertyName -> propertyName;
                }
            }
            throw new IllegalArgumentException(val + " unknown as PropertyNamingStrategy");
        }
        if (PropertyNamingStrategy.class.isInstance(this.value)) {
            return (PropertyNamingStrategy)PropertyNamingStrategy.class.cast(this.value);
        }
        throw new IllegalArgumentException(this.value + " not supported as PropertyNamingStrategy");
    }

    private PropertyNamingStrategy camelCaseStrategy() {
        return propertyName -> Character.toUpperCase(propertyName.charAt(0)) + (propertyName.length() > 1 ? propertyName.substring(1) : "");
    }

    private static class ConfigurableNamingStrategy
    implements PropertyNamingStrategy {
        private final Function<Character, Character> converter;
        private final char separator;

        public ConfigurableNamingStrategy(Function<Character, Character> wordConverter, char sep) {
            this.converter = wordConverter;
            this.separator = sep;
        }

        public String translateName(String propertyName) {
            StringBuilder global = new StringBuilder();
            StringBuilder current = new StringBuilder();
            for (int i = 0; i < propertyName.length(); ++i) {
                char c = propertyName.charAt(i);
                if (Character.isUpperCase(c)) {
                    char transformed = this.converter.apply(Character.valueOf(c)).charValue();
                    if (current.length() > 0) {
                        global.append((CharSequence)current).append(this.separator);
                        current.setLength(0);
                    }
                    current.append(transformed);
                    continue;
                }
                current.append(c);
            }
            if (current.length() > 0) {
                global.append((CharSequence)current);
            } else {
                global.setLength(global.length() - 1);
            }
            return global.toString();
        }
    }
}

