/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

final class JsonNumberImpl
implements JsonNumber,
Serializable {
    private final BigDecimal value;
    private transient Integer hashCode = null;

    JsonNumberImpl(BigDecimal decimal) {
        if (decimal == null) {
            throw new NullPointerException("decimal must not be null");
        }
        this.value = decimal;
    }

    public boolean isIntegral() {
        return this.value.scale() == 0;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public int intValueExact() {
        this.checkFractionalPart();
        return this.value.intValueExact();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public long longValueExact() {
        this.checkFractionalPart();
        return this.value.longValueExact();
    }

    public BigInteger bigIntegerValue() {
        return this.value.toBigInteger();
    }

    public BigInteger bigIntegerValueExact() {
        return this.value.toBigIntegerExact();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.value.hashCode());
        }
        return h;
    }

    public boolean equals(Object obj) {
        return JsonNumber.class.isInstance(obj) && ((JsonNumber)JsonNumber.class.cast(obj)).bigDecimalValue().equals(this.value);
    }

    private void checkFractionalPart() {
        if (this.value.remainder(BigDecimal.ONE).doubleValue() != 0.0) {
            throw new ArithmeticException("Not an int/long, use other value readers");
        }
    }
}

