/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WadlDocumentToJson {
    private final JsonBuilderFactory builderFactory = Json.createBuilderFactory(Collections.emptyMap());

    public String convert(Document doc) throws XMLStreamException {
        JsonObjectBuilder builder = this.builderFactory.createObjectBuilder();
        if (doc.getChildNodes().getLength() != 1) {
            return "{}";
        }
        Node item = doc.getChildNodes().item(0);
        return builder.add(item.getNodeName(), this.createNode(item)).build().toString();
    }

    private void addChildrens(JsonObjectBuilder builder, NodeList children) {
        LinkedHashMap<String, LinkedList<Node>> nodesByName = new LinkedHashMap<String, LinkedList<Node>>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if ("#text".equals(node.getNodeName())) continue;
            String name = node.getNodeName();
            LinkedList<Node> nodes = (LinkedList<Node>)nodesByName.get(name);
            if (nodes == null) {
                nodes = new LinkedList<Node>();
                nodesByName.put(name, nodes);
            }
            nodes.add(node);
        }
        for (Map.Entry entry : nodesByName.entrySet()) {
            JsonArrayBuilder arrayBuilder = this.builderFactory.createArrayBuilder();
            for (Node n : (Collection)entry.getValue()) {
                JsonObjectBuilder jsonObjectBuilder = this.createNode(n);
                if (jsonObjectBuilder == null) continue;
                arrayBuilder.add(jsonObjectBuilder);
            }
            builder.add((String)entry.getKey(), arrayBuilder);
        }
    }

    private JsonObjectBuilder createNode(Node node) {
        JsonObjectBuilder childBuilder = null;
        if (node.hasAttributes()) {
            childBuilder = this.builderFactory.createObjectBuilder();
            NamedNodeMap attributes = node.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node namedItem = attributes.item(j);
                childBuilder.add(namedItem.getNodeName(), namedItem.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            if (childBuilder == null) {
                childBuilder = this.builderFactory.createObjectBuilder();
            }
            this.addChildrens(childBuilder, node.getChildNodes());
        }
        return childBuilder;
    }
}

