/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.json.JsonBuilderFactory;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.config.PropertyNamingStrategy;
import javax.json.bind.config.PropertyVisibilityStrategy;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.Types;
import org.apache.johnzon.jsonb.DefaultPropertyVisibilityStrategy;
import org.apache.johnzon.jsonb.JohnzonJsonb;
import org.apache.johnzon.jsonb.JsonValueParserAdapter;
import org.apache.johnzon.jsonb.JsonbAccessMode;
import org.apache.johnzon.jsonb.PropertyNamingStrategyFactory;
import org.apache.johnzon.jsonb.cdi.CDIs;
import org.apache.johnzon.jsonb.converter.JohnzonJsonbAdapter;
import org.apache.johnzon.jsonb.factory.CdiJohnzonAdapterFactory;
import org.apache.johnzon.jsonb.factory.SimpleJohnzonAdapterFactory;
import org.apache.johnzon.jsonb.serializer.JohnzonDeserializationContext;
import org.apache.johnzon.jsonb.serializer.JohnzonSerializationContext;
import org.apache.johnzon.jsonb.spi.JohnzonAdapterFactory;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.MapperBuilder;
import org.apache.johnzon.mapper.MapperConverter;
import org.apache.johnzon.mapper.MappingParser;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.SerializeValueFilter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.FieldAndMethodAccessMode;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;

public class JohnzonBuilder
implements JsonbBuilder {
    private static final Object NO_BM = new Object();
    private final MapperBuilder builder = new MapperBuilder();
    private JsonProvider jsonp;
    private JsonbConfig config;
    private Object beanManager;
    private CDIs cdiIntegration;

    public JsonbBuilder withConfig(JsonbConfig config) {
        this.config = config;
        return this;
    }

    public JsonbBuilder withProvider(JsonProvider jsonpProvider) {
        this.jsonp = jsonpProvider;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public Jsonb build() {
        if (this.jsonp != null) {
            this.builder.setGeneratorFactory(this.jsonp.createGeneratorFactory(this.generatorConfig()));
            this.builder.setReaderFactory(this.jsonp.createReaderFactory(this.readerConfig()));
        } else {
            this.jsonp = JsonProvider.provider();
        }
        builderFactorySupplier = this.createJsonBuilderFactory();
        parserFactoryProvider = this.createJsonParserFactory();
        if (this.config == null) {
            this.config = new JsonbConfig();
        }
        if (this.config.getProperty("jsonb.formatting").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)(Boolean.class)).orElse(false).booleanValue()) {
            this.builder.setPretty(true);
        }
        this.config.getProperty("jsonb.encoding").ifPresent((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$0(java.lang.Object ), (Ljava/lang/Object;)V)((JohnzonBuilder)this));
        this.config.getProperty("jsonb.null-values").ifPresent((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$1(java.lang.Object ), (Ljava/lang/Object;)V)((JohnzonBuilder)this));
        namingStrategyValue = this.config.getProperty("jsonb.property-naming-strategy");
        propertyNamingStrategy = new PropertyNamingStrategyFactory(namingStrategyValue.orElse("IDENTITY")).create();
        orderValue = this.config.getProperty("jsonb.property-order-strategy").map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, valueOf(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)()).orElse("LEXICOGRAPHICAL");
        visibilityStrategy = this.config.getProperty("jsonb.property-visibility-strategy").map((Function<Object, PropertyVisibilityStrategy>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljavax/json/bind/config/PropertyVisibilityStrategy;)(PropertyVisibilityStrategy.class)).orElse(new DefaultPropertyVisibilityStrategy());
        this.config.getProperty("johnzon.attributeOrder").ifPresent((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$2(java.lang.Object ), (Ljava/lang/Object;)V)((JohnzonBuilder)this));
        this.config.getProperty("johnzon.enforceQuoteString").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build$3(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)()).ifPresent((Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setEnforceQuoteString(boolean ), (Ljava/lang/Boolean;)V)((MapperBuilder)this.builder));
        this.config.getProperty("johnzon.primitiveConverters").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build$4(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)()).ifPresent((Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setPrimitiveConverters(boolean ), (Ljava/lang/Boolean;)V)((MapperBuilder)this.builder));
        this.config.getProperty("johnzon.useBigDecimalForFloats").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build$5(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)()).ifPresent((Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setUseBigDecimalForFloats(boolean ), (Ljava/lang/Boolean;)V)((MapperBuilder)this.builder));
        this.config.getProperty("johnzon.deduplicateObjects").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build$6(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)()).ifPresent((Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setDeduplicateObjects(java.lang.Boolean ), (Ljava/lang/Boolean;)V)((MapperBuilder)this.builder));
        this.config.getProperty("johnzon.interfaceImplementationMapping").map((Function<Object, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/util/Map;)(Map.class)).ifPresent((Consumer<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setInterfaceImplementationMapping(java.util.Map ), (Ljava/util/Map;)V)((MapperBuilder)this.builder));
        defaultConverters = this.createJava8Converters(this.builder);
        factory = this.config.getProperty("johnzon.factory").map((Function<Object, JohnzonAdapterFactory>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build$7(java.lang.Object ), (Ljava/lang/Object;)Lorg/apache/johnzon/jsonb/spi/JohnzonAdapterFactory;)((JohnzonBuilder)this)).orElseGet((Supplier<JohnzonAdapterFactory>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, findFactory(), ()Lorg/apache/johnzon/jsonb/spi/JohnzonAdapterFactory;)((JohnzonBuilder)this));
        accessMode = this.config.getProperty("johnzon.accessMode").map((Function<Object, AccessMode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toAccessMode(java.lang.Object ), (Ljava/lang/Object;)Lorg/apache/johnzon/mapper/access/AccessMode;)((JohnzonBuilder)this)).orElseGet((Supplier<AccessMode>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$build$10(javax.json.bind.config.PropertyNamingStrategy java.lang.String javax.json.bind.config.PropertyVisibilityStrategy java.util.Optional java.util.Map org.apache.johnzon.jsonb.spi.JohnzonAdapterFactory java.util.function.Supplier java.util.function.Supplier ), ()Lorg/apache/johnzon/mapper/access/AccessMode;)((JohnzonBuilder)this, (PropertyNamingStrategy)propertyNamingStrategy, (String)orderValue, (PropertyVisibilityStrategy)visibilityStrategy, (Optional)namingStrategyValue, defaultConverters, (JohnzonAdapterFactory)factory, builderFactorySupplier, parserFactoryProvider));
        this.builder.setAccessMode(accessMode);
        this.config.getProperty("jsonb.adapters").ifPresent((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$13(java.util.Map java.lang.Object ), (Ljava/lang/Object;)V)((JohnzonBuilder)this, defaultConverters));
        this.config.getProperty("jsonb.strict-ijson").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)(Boolean.class)).ifPresent((Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$14(java.lang.Boolean ), (Ljava/lang/Boolean;)V)());
        this.config.getProperty("johnzon.fail-on-unknown-properties").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build$15(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)()).ifPresent((Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setFailOnUnknownProperties(boolean ), (Ljava/lang/Boolean;)V)((MapperBuilder)this.builder));
        this.config.getProperty("jsonb.binary-data-strategy").map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(String.class)).ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$16(java.lang.String ), (Ljava/lang/String;)V)((JohnzonBuilder)this));
        this.getBeanManager();
        types = new Types();
        this.builder.setReadAttributeBeforeWrite(this.config.getProperty("johnzon.readAttributeBeforeWrite").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)(Boolean.class)).orElse(false).booleanValue());
        this.builder.setAutoAdjustStringBuffers(this.config.getProperty("johnzon.autoAdjustBuffer").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)(Boolean.class)).orElse(true).booleanValue());
        this.config.getProperty("johnzon.serialize-value-filter").map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build$17(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)()).ifPresent((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$18(java.lang.Object ), (Ljava/lang/Object;)V)((JohnzonBuilder)this));
        this.config.getProperty("jsonb.serializers").map((Function<Object, JsonbSerializer[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)[Ljavax/json/bind/serializer/JsonbSerializer;)(JsonbSerializer[].class)).ifPresent((Consumer<JsonbSerializer[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$21(org.apache.johnzon.core.Types javax.json.bind.serializer.JsonbSerializer[] ), ([Ljavax/json/bind/serializer/JsonbSerializer;)V)((JohnzonBuilder)this, (Types)types));
        this.config.getProperty("jsonb.derializers").map((Function<Object, JsonbDeserializer[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)[Ljavax/json/bind/serializer/JsonbDeserializer;)(JsonbDeserializer[].class)).ifPresent((Consumer<JsonbDeserializer[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$24(org.apache.johnzon.core.Types java.util.function.Supplier java.util.function.Supplier javax.json.bind.serializer.JsonbDeserializer[] ), ([Ljavax/json/bind/serializer/JsonbDeserializer;)V)((JohnzonBuilder)this, (Types)types, builderFactorySupplier, parserFactoryProvider));
        if (this.cdiIntegration == null || !this.cdiIntegration.isCanWrite()) ** GOTO lbl-1000
        if (this.config.getProperty("johnzon.cdi.activated").map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)(Boolean.class)).orElse(Boolean.TRUE).booleanValue()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = useCdi = false;
        }
        if (Closeable.class.isInstance(accessMode)) {
            this.builder.addCloseable((Closeable)Closeable.class.cast(accessMode));
        }
        mapper = this.builder.build();
        return useCdi != false ? new JohnzonJsonb(mapper){
            {
                JohnzonBuilder.this.cdiIntegration.track(this);
            }

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    if (JohnzonBuilder.this.cdiIntegration.isCanWrite()) {
                        JohnzonBuilder.this.cdiIntegration.untrack(this);
                    }
                }
            }
        } : new JohnzonJsonb(mapper);
    }

    private AccessMode toAccessMode(Object s) {
        if (String.class.isInstance(s)) {
            try {
                return (AccessMode)AccessMode.class.cast(Thread.currentThread().getContextClassLoader().loadClass(s.toString()).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e.getCause());
            }
        }
        return (AccessMode)AccessMode.class.cast(s);
    }

    private Supplier<JsonParserFactory> createJsonParserFactory() {
        return new Lazy<JsonParserFactory>(){

            @Override
            protected JsonParserFactory doCreate() {
                return JohnzonBuilder.this.jsonp.createParserFactory(Collections.emptyMap());
            }
        };
    }

    private Supplier<JsonBuilderFactory> createJsonBuilderFactory() {
        return new Lazy<JsonBuilderFactory>(){

            @Override
            protected JsonBuilderFactory doCreate() {
                return JohnzonBuilder.this.jsonp.createBuilderFactory(Collections.emptyMap());
            }
        };
    }

    private Object getBeanManager() {
        if (this.beanManager == null) {
            try {
                Class<?> cdi = this.tccl().loadClass("javax.enterprise.inject.spi.CDI");
                Object cdiInstance = cdi.getMethod("current", new Class[0]).invoke(null, new Object[0]);
                this.beanManager = cdi.getMethod("getBeanManager", new Class[0]).invoke(cdiInstance, new Object[0]);
                this.cdiIntegration = new CDIs(this.beanManager);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.beanManager = NO_BM;
            }
        }
        return this.beanManager;
    }

    private JohnzonAdapterFactory findFactory() {
        if (this.getBeanManager() == NO_BM || this.config.getProperty("johnzon.skip-cdi").map(s -> "true".equalsIgnoreCase(String.valueOf(s))).orElse(false).booleanValue()) {
            return new SimpleJohnzonAdapterFactory();
        }
        try {
            return new CdiJohnzonAdapterFactory(this.beanManager);
        }
        catch (Exception | NoClassDefFoundError e) {
            return new SimpleJohnzonAdapterFactory();
        }
    }

    private ClassLoader tccl() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
    }

    private Map<AdapterKey, Adapter<?, ?>> createJava8Converters(MapperBuilder builder) {
        HashMap converters = new HashMap();
        final TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
        final ZoneId zoneIDUTC = ZoneId.of("UTC");
        converters.put(new AdapterKey(Period.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Period>(){

            public String toString(Period instance) {
                return instance.toString();
            }

            public Period fromString(String text) {
                return Period.parse(text);
            }
        }));
        converters.put(new AdapterKey(Duration.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Duration>(){

            public String toString(Duration instance) {
                return instance.toString();
            }

            public Duration fromString(String text) {
                return Duration.parse(text);
            }
        }));
        converters.put(new AdapterKey(Date.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Date>(){

            public String toString(Date instance) {
                return LocalDateTime.ofInstant(instance.toInstant(), zoneIDUTC).toString();
            }

            public Date fromString(String text) {
                return Date.from(LocalDateTime.parse(text).toInstant(ZoneOffset.UTC));
            }
        }));
        converters.put(new AdapterKey(Calendar.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Calendar>(){

            public String toString(Calendar instance) {
                return ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC).toString();
            }

            public Calendar fromString(String text) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(timeZoneUTC);
                calendar.setTimeInMillis(ZonedDateTime.parse(text).toInstant().toEpochMilli());
                return calendar;
            }
        }));
        converters.put(new AdapterKey(GregorianCalendar.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<GregorianCalendar>(){

            public String toString(GregorianCalendar instance) {
                return instance.toZonedDateTime().toString();
            }

            public GregorianCalendar fromString(String text) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTimeZone(timeZoneUTC);
                calendar.setTimeInMillis(ZonedDateTime.parse(text).toInstant().toEpochMilli());
                return calendar;
            }
        }));
        converters.put(new AdapterKey(TimeZone.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<TimeZone>(){

            public String toString(TimeZone instance) {
                return instance.getID();
            }

            public TimeZone fromString(String text) {
                JohnzonBuilder.logIfDeprecatedTimeZone(text);
                return TimeZone.getTimeZone(text);
            }
        }));
        converters.put(new AdapterKey(ZoneId.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<ZoneId>(){

            public String toString(ZoneId instance) {
                return instance.getId();
            }

            public ZoneId fromString(String text) {
                return ZoneId.of(text);
            }
        }));
        converters.put(new AdapterKey(ZoneOffset.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<ZoneOffset>(){

            public String toString(ZoneOffset instance) {
                return instance.getId();
            }

            public ZoneOffset fromString(String text) {
                return ZoneOffset.of(text);
            }
        }));
        converters.put(new AdapterKey(SimpleTimeZone.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<SimpleTimeZone>(){

            public String toString(SimpleTimeZone instance) {
                return instance.getID();
            }

            public SimpleTimeZone fromString(String text) {
                JohnzonBuilder.logIfDeprecatedTimeZone(text);
                TimeZone timeZone = TimeZone.getTimeZone(text);
                return new SimpleTimeZone(timeZone.getRawOffset(), timeZone.getID());
            }
        }));
        converters.put(new AdapterKey(Instant.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Instant>(){

            public String toString(Instant instance) {
                return instance.toString();
            }

            public Instant fromString(String text) {
                return Instant.parse(text);
            }
        }));
        converters.put(new AdapterKey(LocalDate.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<LocalDate>(){

            public String toString(LocalDate instance) {
                return instance.toString();
            }

            public LocalDate fromString(String text) {
                return LocalDate.parse(text);
            }
        }));
        converters.put(new AdapterKey(LocalTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<LocalTime>(){

            public String toString(LocalTime instance) {
                return instance.toString();
            }

            public LocalTime fromString(String text) {
                return LocalTime.parse(text);
            }
        }));
        converters.put(new AdapterKey(LocalDateTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<LocalDateTime>(){

            public String toString(LocalDateTime instance) {
                return instance.toString();
            }

            public LocalDateTime fromString(String text) {
                return LocalDateTime.parse(text);
            }
        }));
        converters.put(new AdapterKey(ZonedDateTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<ZonedDateTime>(){

            public String toString(ZonedDateTime instance) {
                return instance.toString();
            }

            public ZonedDateTime fromString(String text) {
                return ZonedDateTime.parse(text);
            }
        }));
        converters.put(new AdapterKey(OffsetDateTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<OffsetDateTime>(){

            public String toString(OffsetDateTime instance) {
                return instance.toString();
            }

            public OffsetDateTime fromString(String text) {
                return OffsetDateTime.parse(text);
            }
        }));
        converters.put(new AdapterKey(OffsetTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<OffsetTime>(){

            public String toString(OffsetTime instance) {
                return instance.toString();
            }

            public OffsetTime fromString(String text) {
                return OffsetTime.parse(text);
            }
        }));
        this.addDateFormatConfigConverters(converters, zoneIDUTC);
        converters.forEach((k, v) -> builder.addAdapter(k.getFrom(), k.getTo(), v));
        return converters;
    }

    private void addDateFormatConfigConverters(Map<AdapterKey, Adapter<?, ?>> converters, final ZoneId zoneIDUTC) {
        this.config.getProperty("jsonb.date-format").map(String.class::cast).ifPresent(dateFormat -> {
            Optional<Locale> locale = this.config.getProperty("jsonb.locale").map(Locale.class::cast);
            final DateTimeFormatter formatter = locale.isPresent() ? DateTimeFormatter.ofPattern(dateFormat, locale.get()) : DateTimeFormatter.ofPattern(dateFormat);
            converters.put(new AdapterKey(Date.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Date>(){

                public String toString(Date instance) {
                    return formatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                public Date fromString(String text) {
                    try {
                        return Date.from(JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC).toInstant());
                    }
                    catch (DateTimeParseException dpe) {
                        return Date.from(LocalDateTime.parse(text).toInstant(ZoneOffset.UTC));
                    }
                }
            }));
            converters.put(new AdapterKey(LocalDateTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<LocalDateTime>(){

                public String toString(LocalDateTime instance) {
                    return formatter.format(ZonedDateTime.ofInstant(instance.toInstant(ZoneOffset.UTC), zoneIDUTC));
                }

                public LocalDateTime fromString(String text) {
                    try {
                        return JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC).toLocalDateTime();
                    }
                    catch (DateTimeParseException dpe) {
                        return LocalDateTime.parse(text);
                    }
                }
            }));
            converters.put(new AdapterKey(LocalDate.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<LocalDate>(){

                public String toString(LocalDate instance) {
                    return formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(TimeUnit.DAYS.toMillis(instance.toEpochDay())), zoneIDUTC));
                }

                public LocalDate fromString(String text) {
                    try {
                        return JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC).toLocalDate();
                    }
                    catch (DateTimeParseException dpe) {
                        return LocalDate.parse(text);
                    }
                }
            }));
            converters.put(new AdapterKey(OffsetDateTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<OffsetDateTime>(){

                public String toString(OffsetDateTime instance) {
                    return formatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                public OffsetDateTime fromString(String text) {
                    try {
                        return JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC).toOffsetDateTime();
                    }
                    catch (DateTimeParseException dpe) {
                        return OffsetDateTime.parse(text);
                    }
                }
            }));
            converters.put(new AdapterKey(ZonedDateTime.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<ZonedDateTime>(){

                public String toString(ZonedDateTime instance) {
                    return formatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                public ZonedDateTime fromString(String text) {
                    try {
                        return JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC);
                    }
                    catch (DateTimeParseException dpe) {
                        return ZonedDateTime.parse(text);
                    }
                }
            }));
            converters.put(new AdapterKey(Calendar.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Calendar>(){

                public String toString(Calendar instance) {
                    return formatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                public Calendar fromString(String text) {
                    Calendar instance = Calendar.getInstance();
                    instance.setTime(Date.from(JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC).toInstant()));
                    return instance;
                }
            }));
            converters.put(new AdapterKey(GregorianCalendar.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<GregorianCalendar>(){

                public String toString(GregorianCalendar instance) {
                    return formatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                public GregorianCalendar fromString(String text) {
                    Calendar instance = GregorianCalendar.getInstance();
                    instance.setTime(Date.from(JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC).toInstant()));
                    return (GregorianCalendar)GregorianCalendar.class.cast(instance);
                }
            }));
            converters.put(new AdapterKey(Instant.class, String.class), (Adapter<?, ?>)new ConverterAdapter((Converter)new Converter<Instant>(){

                public String toString(Instant instance) {
                    return formatter.format(ZonedDateTime.ofInstant(instance, zoneIDUTC));
                }

                public Instant fromString(String text) {
                    return JohnzonBuilder.parseZonedDateTime(text, formatter, zoneIDUTC).toInstant();
                }
            }));
        });
    }

    private static ZonedDateTime parseZonedDateTime(String text, DateTimeFormatter formatter, ZoneId defaultZone) {
        TemporalAccessor parse = formatter.parse(text);
        ZoneId zone = parse.query(TemporalQueries.zone());
        if (Objects.isNull(zone)) {
            zone = defaultZone;
        }
        int year = parse.isSupported(ChronoField.YEAR) ? parse.get(ChronoField.YEAR) : 0;
        int month = parse.isSupported(ChronoField.MONTH_OF_YEAR) ? parse.get(ChronoField.MONTH_OF_YEAR) : 0;
        int day = parse.isSupported(ChronoField.DAY_OF_MONTH) ? parse.get(ChronoField.DAY_OF_MONTH) : 0;
        int hour = parse.isSupported(ChronoField.HOUR_OF_DAY) ? parse.get(ChronoField.HOUR_OF_DAY) : 0;
        int minute = parse.isSupported(ChronoField.MINUTE_OF_HOUR) ? parse.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int second = parse.isSupported(ChronoField.SECOND_OF_MINUTE) ? parse.get(ChronoField.SECOND_OF_MINUTE) : 0;
        int millisecond = parse.isSupported(ChronoField.MILLI_OF_SECOND) ? parse.get(ChronoField.MILLI_OF_SECOND) : 0;
        return ZonedDateTime.of(year, month, day, hour, minute, second, millisecond, zone);
    }

    private static void logIfDeprecatedTimeZone(String text) {
    }

    private Map<String, ?> generatorConfig() {
        HashMap map = new HashMap();
        if (this.config == null) {
            return map;
        }
        this.config.getProperty("org.apache.johnzon.default-char-buffer-generator").ifPresent(b -> map.put("org.apache.johnzon.default-char-buffer-generator", b));
        this.config.getProperty("org.apache.johnzon.buffer-strategy").ifPresent(b -> map.put("org.apache.johnzon.buffer-strategy", b));
        this.config.getProperty("jsonb.formatting").ifPresent(b -> map.put("javax.json.stream.JsonGenerator.prettyPrinting", b));
        return map;
    }

    private Map<String, ?> readerConfig() {
        HashMap map = new HashMap();
        if (this.config == null) {
            return map;
        }
        this.config.getProperty("org.apache.johnzon.default-char-buffer").ifPresent(b -> map.put("org.apache.johnzon.default-char-buffer", b));
        this.config.getProperty("org.apache.johnzon.max-string-length").ifPresent(b -> map.put("org.apache.johnzon.max-string-length", b));
        this.config.getProperty("org.apache.johnzon.supports-comments").ifPresent(b -> map.put("org.apache.johnzon.supports-comments", b));
        this.config.getProperty("org.apache.johnzon.buffer-strategy").ifPresent(b -> map.put("org.apache.johnzon.buffer-strategy", b));
        return map;
    }

    private /* synthetic */ void lambda$build$24(Types types, Supplier builderFactorySupplier, Supplier parserFactoryProvider, JsonbDeserializer[] deserializers) {
        Stream.of(deserializers).forEach(arg_0 -> this.lambda$null$23(types, (Supplier)builderFactorySupplier, (Supplier)parserFactoryProvider, arg_0));
    }

    private /* synthetic */ void lambda$null$23(Types types, Supplier builderFactorySupplier, Supplier parserFactoryProvider, JsonbDeserializer d) {
        ParameterizedType pt = types.findParameterizedType(d.getClass(), JsonbDeserializer.class);
        Type[] args = pt.getActualTypeArguments();
        if (args.length != 1 || !Class.class.isInstance(args[0])) {
            throw new IllegalArgumentException("We only support deserializer on Class for now");
        }
        JsonBuilderFactory builderFactory = (JsonBuilderFactory)builderFactorySupplier.get();
        this.builder.addObjectConverter((Class)Class.class.cast(args[0]), (MapperConverter)((ObjectConverter.Reader)(arg_0, arg_1, arg_2) -> this.lambda$null$22(d, (Supplier)parserFactoryProvider, builderFactory, arg_0, arg_1, arg_2)));
    }

    private /* synthetic */ Object lambda$null$22(JsonbDeserializer d, Supplier parserFactoryProvider, JsonBuilderFactory builderFactory, JsonValue jsonObject, Type targetType, MappingParser parser) {
        return d.deserialize(JsonValueParserAdapter.createFor(jsonObject, parserFactoryProvider), (DeserializationContext)new JohnzonDeserializationContext(parser, builderFactory, this.jsonp), targetType);
    }

    private /* synthetic */ void lambda$build$21(Types types, JsonbSerializer[] serializers) {
        Stream.of(serializers).forEach(s -> {
            ParameterizedType pt = types.findParameterizedType(s.getClass(), JsonbSerializer.class);
            Type[] args = pt.getActualTypeArguments();
            if (args.length != 1 || !Class.class.isInstance(args[0])) {
                throw new IllegalArgumentException("We only support serializer on Class for now");
            }
            this.builder.addObjectConverter((Class)Class.class.cast(args[0]), (MapperConverter)((ObjectConverter.Writer)(instance, jsonbGenerator) -> s.serialize(instance, jsonbGenerator.getJsonGenerator(), (SerializationContext)new JohnzonSerializationContext(jsonbGenerator))));
        });
    }

    private /* synthetic */ void lambda$build$18(Object s) {
        this.builder.setSerializeValueFilter((SerializeValueFilter)SerializeValueFilter.class.cast(s));
    }

    private static /* synthetic */ Object lambda$build$17(Object s) {
        if (String.class.isInstance(s)) {
            try {
                return SerializeValueFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(s.toString()).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e.getCause());
            }
        }
        return s;
    }

    private /* synthetic */ void lambda$build$16(String bin) {
        switch (bin) {
            case "BYTE": {
                break;
            }
            case "BASE_64": {
                this.builder.setTreatByteArrayAsBase64(true);
                break;
            }
            case "BASE_64_URL": {
                this.builder.addConverter(byte[].class, (Converter)new Converter<byte[]>(){

                    public String toString(byte[] instance) {
                        return Base64.getUrlEncoder().encodeToString(instance);
                    }

                    public byte[] fromString(String text) {
                        return Base64.getUrlDecoder().decode(text.getBytes(StandardCharsets.UTF_8));
                    }
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported binary configuration: " + bin);
            }
        }
    }

    private static /* synthetic */ Boolean lambda$build$15(Object v) {
        return Boolean.class.isInstance(v) ? (Boolean)Boolean.class.cast(v) : Boolean.valueOf(Boolean.parseBoolean(String.valueOf(v)));
    }

    private static /* synthetic */ void lambda$build$14(Boolean ijson) {
    }

    private /* synthetic */ void lambda$build$13(Map defaultConverters, Object adapters) {
        Stream.of((Object[])JsonbAdapter[].class.cast(adapters)).forEach(adapter -> {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(Stream.of(adapter.getClass().getGenericInterfaces()).filter(i -> ParameterizedType.class.isInstance(i) && ((ParameterizedType)ParameterizedType.class.cast(i)).getRawType() == JsonbAdapter.class).findFirst().orElse(null));
            if (pt == null) {
                throw new IllegalArgumentException(adapter + " doesn't implement JsonbAdapter");
            }
            Type[] args = pt.getActualTypeArguments();
            JohnzonJsonbAdapter johnzonJsonbAdapter = new JohnzonJsonbAdapter(adapter, args[0], args[1]);
            this.builder.addAdapter(args[0], args[1], johnzonJsonbAdapter);
            defaultConverters.put(new AdapterKey(args[0], args[1]), johnzonJsonbAdapter);
        });
    }

    private /* synthetic */ AccessMode lambda$build$10(PropertyNamingStrategy propertyNamingStrategy, String orderValue, PropertyVisibilityStrategy visibilityStrategy, Optional namingStrategyValue, Map defaultConverters, JohnzonAdapterFactory factory, Supplier builderFactorySupplier, Supplier parserFactoryProvider) {
        return new JsonbAccessMode(propertyNamingStrategy, orderValue, visibilityStrategy, !namingStrategyValue.orElse("").equals("CASE_INSENSITIVE"), defaultConverters, factory, this.jsonp, builderFactorySupplier, parserFactoryProvider, this.config.getProperty("johnzon.accessModeDelegate").map(this::toAccessMode).orElseGet(() -> new FieldAndMethodAccessMode(true, true, false)), this.config.getProperty("johnzon.failOnMissingCreatorValues").map(it -> String.class.isInstance(it) ? Boolean.valueOf(Boolean.parseBoolean(it.toString())) : (Boolean)Boolean.class.cast(it)).orElse(true));
    }

    private /* synthetic */ JohnzonAdapterFactory lambda$build$7(Object val) {
        if (JohnzonAdapterFactory.class.isInstance(val)) {
            return (JohnzonAdapterFactory)JohnzonAdapterFactory.class.cast(val);
        }
        if (String.class.isInstance(val)) {
            try {
                return (JohnzonAdapterFactory)JohnzonAdapterFactory.class.cast(this.tccl().loadClass(val.toString()).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (Class.class.isInstance(val)) {
            try {
                return (JohnzonAdapterFactory)JohnzonAdapterFactory.class.cast(((Class)Class.class.cast(val)).newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Unsupported factory: " + val);
    }

    private static /* synthetic */ Boolean lambda$build$6(Object v) {
        return !Boolean.class.isInstance(v) ? Boolean.valueOf(Boolean.parseBoolean(v.toString())) : (Boolean)Boolean.class.cast(v);
    }

    private static /* synthetic */ Boolean lambda$build$5(Object v) {
        return !Boolean.class.isInstance(v) ? Boolean.valueOf(Boolean.parseBoolean(v.toString())) : (Boolean)Boolean.class.cast(v);
    }

    private static /* synthetic */ Boolean lambda$build$4(Object v) {
        return !Boolean.class.isInstance(v) ? Boolean.valueOf(Boolean.parseBoolean(v.toString())) : (Boolean)Boolean.class.cast(v);
    }

    private static /* synthetic */ Boolean lambda$build$3(Object v) {
        return !Boolean.class.isInstance(v) ? Boolean.valueOf(Boolean.parseBoolean(v.toString())) : (Boolean)Boolean.class.cast(v);
    }

    private /* synthetic */ void lambda$build$2(Object comp) {
        this.builder.setAttributeOrder((Comparator)Comparator.class.cast(comp));
    }

    private /* synthetic */ void lambda$build$1(Object serNulls) {
        this.builder.setSkipNull((Boolean)Boolean.class.cast(serNulls) == false);
    }

    private /* synthetic */ void lambda$build$0(Object encoding) {
        this.builder.setEncoding(String.valueOf(encoding));
    }

    private static abstract class Lazy<T>
    implements Supplier<T> {
        private final AtomicReference<T> ref = new AtomicReference();

        private Lazy() {
        }

        @Override
        public T get() {
            T factory = this.ref.get();
            if (factory == null && !this.ref.compareAndSet(null, factory = this.doCreate())) {
                factory = this.ref.get();
            }
            return factory;
        }

        protected abstract T doCreate();
    }
}

