/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.MapperConfig;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.MappingParser;
import org.apache.johnzon.mapper.Mappings;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.TypeAwareAdapter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.converter.CharacterConverter;
import org.apache.johnzon.mapper.converter.EnumConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.internal.JsonPointerTracker;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public class MappingParserImpl
implements MappingParser {
    private static final JohnzonParameterizedType ANY_LIST = new JohnzonParameterizedType((Type)((Object)List.class), new Type[]{Object.class});
    private static final CharacterConverter CHARACTER_CONVERTER = new CharacterConverter();
    protected final ConcurrentMap<Class<?>, Method> valueOfs = new ConcurrentHashMap();
    private final MapperConfig config;
    private final Mappings mappings;
    private final boolean isDeduplicateObjects;
    private final JsonReader jsonReader;
    private Map<String, Object> jsonPointers;

    public MappingParserImpl(MapperConfig config, Mappings mappings, JsonReader jsonReader, boolean isDeduplicateObjects) {
        this.config = config;
        this.mappings = mappings;
        this.jsonReader = jsonReader;
        this.isDeduplicateObjects = isDeduplicateObjects;
        this.jsonPointers = isDeduplicateObjects ? new HashMap<String, Object>() : Collections.emptyMap();
    }

    @Override
    public <T> T readObject(Type targetType) {
        try {
            return this.readObject(this.jsonReader.readValue(), targetType);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return this.readObject((JsonValue)this.jsonReader.read(), targetType);
        }
    }

    @Override
    public <T> T readObject(JsonValue jsonValue, Type targetType) {
        return this.readObject(jsonValue, targetType, targetType instanceof Class || targetType instanceof ParameterizedType);
    }

    private <T> T readObject(JsonValue jsonValue, Type targetType, boolean applyObjectConverter) {
        JsonValue.ValueType valueType;
        JsonValue.ValueType valueType2 = valueType = jsonValue != null ? jsonValue.getValueType() : null;
        if (JsonStructure.class == targetType || JsonObject.class == targetType || JsonValue.class == targetType) {
            return (T)jsonValue;
        }
        if (JsonObject.class.isInstance(jsonValue)) {
            return (T)this.buildObject(targetType, (JsonObject)JsonObject.class.cast(jsonValue), applyObjectConverter, this.isDeduplicateObjects ? new JsonPointerTracker(null, "/") : null);
        }
        if (JsonString.class.isInstance(jsonValue) && (targetType == String.class || targetType == Object.class)) {
            return (T)((JsonString)JsonString.class.cast(jsonValue)).getString();
        }
        if (JsonNumber.class.isInstance(jsonValue)) {
            JsonNumber number = (JsonNumber)JsonNumber.class.cast(jsonValue);
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (T)Integer.valueOf(number.intValue());
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return (T)Long.valueOf(number.longValue());
            }
            if (targetType == Double.TYPE || targetType == Double.class || targetType == Object.class) {
                return (T)Double.valueOf(number.doubleValue());
            }
            if (targetType == BigDecimal.class) {
                return (T)number.bigDecimalValue();
            }
            if (targetType == BigInteger.class) {
                return (T)number.bigIntegerValue();
            }
        }
        if (JsonArray.class.isInstance(jsonValue)) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            if (Class.class.isInstance(targetType) && ((Class)targetType).isArray()) {
                Class<?> componentType = ((Class)targetType).getComponentType();
                return (T)this.buildArrayWithComponentType(jsonArray, componentType, this.config.findAdapter(componentType), this.isDeduplicateObjects ? new JsonPointerTracker(null, "/") : null, (Type)((Object)Object.class));
            }
            if (ParameterizedType.class.isInstance(targetType)) {
                ParameterizedType pt = (ParameterizedType)targetType;
                Mappings.CollectionMapping mapping = this.mappings.findCollectionMapping(pt, (Type)((Object)Object.class));
                if (mapping == null) {
                    throw new UnsupportedOperationException("type " + targetType + " not supported");
                }
                Type arg = pt.getActualTypeArguments()[0];
                return (T)this.mapCollection(mapping, jsonArray, Class.class.isInstance(arg) ? this.config.findAdapter((Type)Class.class.cast(arg)) : null, null, this.isDeduplicateObjects ? new JsonPointerTracker(null, "/") : null, (Type)((Object)Object.class));
            }
            if (Object.class == targetType) {
                return (T)new ArrayList<Object>(Arrays.asList((Object[])Object[].class.cast(this.buildArrayWithComponentType(jsonArray, Object.class, null, this.isDeduplicateObjects ? new JsonPointerTracker(null, "/") : null, (Type)((Object)Object.class)))));
            }
        }
        if (JsonValue.ValueType.NULL == valueType) {
            return null;
        }
        if (JsonValue.ValueType.TRUE == valueType && (Boolean.class == targetType || Boolean.TYPE == targetType || Object.class == targetType)) {
            return (T)Boolean.TRUE;
        }
        if (JsonValue.ValueType.FALSE == valueType && (Boolean.class == targetType || Boolean.TYPE == targetType || Object.class == targetType)) {
            return (T)Boolean.FALSE;
        }
        throw new IllegalArgumentException("Unsupported " + jsonValue + " for type " + targetType);
    }

    private Object buildObject(Type inType, JsonObject object, boolean applyObjectConverter, JsonPointerTracker jsonPointer) {
        Mappings.ClassMapping classMapping;
        Type type = inType;
        if (inType == Object.class) {
            type = new JohnzonParameterizedType((Type)((Object)Map.class), new Type[]{String.class, Object.class});
        }
        if (applyObjectConverter && !(type instanceof ParameterizedType)) {
            if (!(type instanceof Class)) {
                throw new MapperException("ObjectConverters are only supported for Classes not Types");
            }
            ObjectConverter.Reader objectConverter = this.config.findObjectConverterReader((Class)type);
            if (objectConverter != null) {
                return objectConverter.fromJson((JsonValue)object, type, new SuppressConversionMappingParser(this, object));
            }
        }
        if ((classMapping = this.mappings.findOrCreateClassMapping(type)) == null) {
            if (ParameterizedType.class.isInstance(type)) {
                Class raw;
                AbstractMap map;
                ParameterizedType aType = (ParameterizedType)ParameterizedType.class.cast(type);
                Type[] fieldArgTypes = aType.getActualTypeArguments();
                if (fieldArgTypes.length >= 2 && (map = LinkedHashMap.class == (raw = (Class)Class.class.cast(aType.getRawType())) ? new LinkedHashMap() : (SortedMap.class.isAssignableFrom(raw) || NavigableMap.class == raw || TreeMap.class == raw ? (this.config.getAttributeOrder() == null ? new TreeMap() : new TreeMap(this.config.getAttributeOrder())) : (ConcurrentMap.class.isAssignableFrom(raw) ? new ConcurrentHashMap(object.size()) : (EnumMap.class.isAssignableFrom(raw) ? new EnumMap((Class)Class.class.cast(fieldArgTypes[0])) : (Map.class.isAssignableFrom(raw) ? new HashMap(object.size()) : null))))) != null) {
                    Type keyType = ParameterizedType.class.isInstance(fieldArgTypes[0]) ? fieldArgTypes[0] : fieldArgTypes[0];
                    boolean any = fieldArgTypes.length < 2 || fieldArgTypes[1] == Object.class;
                    for (Map.Entry value : object.entrySet()) {
                        JsonValue jsonValue = (JsonValue)value.getValue();
                        if (JsonNumber.class.isInstance(jsonValue) && any) {
                            map.put(value.getKey(), this.toNumberValue((JsonNumber)JsonNumber.class.cast(jsonValue)));
                            continue;
                        }
                        if (JsonString.class.isInstance(jsonValue) && any) {
                            map.put(value.getKey(), ((JsonString)JsonString.class.cast(jsonValue)).getString());
                            continue;
                        }
                        map.put(this.convertTo(keyType, (String)value.getKey()), this.toObject(null, jsonValue, fieldArgTypes[1], null, jsonPointer, (Type)((Object)Object.class)));
                    }
                    return map;
                }
            } else if (Map.class == type || HashMap.class == type || LinkedHashMap.class == type) {
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry value : object.entrySet()) {
                    map.put(value.getKey(), this.toObject(null, (JsonValue)value.getValue(), (Type)((Object)Object.class), null, jsonPointer, (Type)((Object)Object.class)));
                }
                return map;
            }
        }
        if (classMapping == null) {
            throw new MapperException("Can't map " + type);
        }
        if (applyObjectConverter && classMapping.reader != null) {
            return classMapping.reader.fromJson((JsonValue)object, type, new SuppressConversionMappingParser(this, object));
        }
        if (classMapping.factory == null) {
            throw new MapperException(classMapping.clazz + " not instantiable");
        }
        if (this.config.isFailOnUnknown() && !classMapping.setters.keySet().containsAll(object.keySet())) {
            throw new MapperException("(fail on unknown properties): " + new HashSet<String>((Collection)object.keySet()){
                {
                    super(x0);
                    this.removeAll(classMapping.setters.keySet());
                }
            });
        }
        Object t = classMapping.factory.getParameterTypes().length == 0 ? classMapping.factory.create(null) : classMapping.factory.create(this.createParameters(classMapping, object, jsonPointer));
        if (this.isDeduplicateObjects) {
            this.jsonPointers.put(jsonPointer.toString(), t);
        }
        for (Map.Entry<String, Mappings.Setter> setter : classMapping.setters.entrySet()) {
            Object convertedValue;
            Mappings.Getter getter;
            JsonValue jsonValue = (JsonValue)object.get((Object)setter.getKey());
            JsonValue.ValueType valueType = jsonValue != null ? jsonValue.getValueType() : null;
            Mappings.Setter value = setter.getValue();
            if (JsonValue.class == value.paramType) {
                setter.getValue().writer.write(t, jsonValue);
                continue;
            }
            if (jsonValue == null) continue;
            AccessMode.Writer setterMethod = value.writer;
            if (JsonValue.ValueType.NULL == valueType) {
                setterMethod.write(t, null);
                continue;
            }
            Object existingInstance = null;
            if (this.config.isReadAttributeBeforeWrite() && (getter = classMapping.getters.get(setter.getKey())) != null) {
                try {
                    existingInstance = getter.reader.read(t);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if ((convertedValue = this.toValue(existingInstance, jsonValue, value.converter, value.itemConverter, value.paramType, value.objectConverter, new JsonPointerTracker(jsonPointer, setter.getKey()), inType)) == null) continue;
            setterMethod.write(t, convertedValue);
        }
        if (classMapping.anySetter != null) {
            for (Map.Entry<String, Mappings.Setter> entry : object.entrySet()) {
                String key = entry.getKey();
                if (classMapping.setters.containsKey(key)) continue;
                try {
                    classMapping.anySetter.invoke(t, key, this.toValue(null, (JsonValue)entry.getValue(), null, null, (Type)((Object)Object.class), null, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, entry.getKey()) : null, type));
                }
                catch (IllegalAccessException e2) {
                    throw new IllegalStateException(e2);
                }
                catch (InvocationTargetException e3) {
                    throw new MapperException(e3.getCause());
                }
            }
        }
        if (classMapping.mapAdder != null) {
            object.entrySet().stream().filter(it -> !classMapping.setters.containsKey(it.getKey())).filter(it -> ((JsonValue)it.getValue()).getValueType() != JsonValue.ValueType.NULL).forEach(e -> {
                Object convertedValue = this.toValue(null, (JsonValue)e.getValue(), null, null, classMapping.mapAdderType, null, new JsonPointerTracker(jsonPointer, (String)e.getKey()), inType);
                if (convertedValue != null) {
                    try {
                        classMapping.mapAdder.invoke(t, e.getKey(), convertedValue);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalStateException(ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new MapperException(ex.getCause());
                    }
                }
            });
        }
        return t;
    }

    private Number toNumberValue(JsonNumber jsonNumber) {
        if (jsonNumber.isIntegral()) {
            long longValue;
            int intValue = jsonNumber.intValue();
            if ((long)intValue == (longValue = jsonNumber.longValue())) {
                return intValue;
            }
            return longValue;
        }
        if (this.config.isUseBigDecimalForFloats()) {
            return jsonNumber.bigDecimalValue();
        }
        return jsonNumber.doubleValue();
    }

    private Object convertTo(Adapter converter, JsonValue jsonValue, JsonPointerTracker jsonPointer) {
        JsonValue.ValueType valueType = jsonValue != null ? jsonValue.getValueType() : null;
        AdapterKey key = this.getAdapterKey(converter);
        if (JsonValue.class == key.getTo()) {
            return converter.to(jsonValue);
        }
        if (JsonValue.ValueType.OBJECT == valueType) {
            Object param;
            if (JsonObject.class == key.getTo() || JsonStructure.class == key.getTo()) {
                return converter.to(jsonValue.asJsonObject());
            }
            AdapterKey adapterKey = this.getAdapterKey(converter);
            try {
                Type to = adapterKey.getTo();
                param = this.buildObject(to, (JsonObject)JsonObject.class.cast(jsonValue), to instanceof Class, jsonPointer);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
            return converter.to(param);
        }
        if (JsonValue.ValueType.NULL.equals((Object)valueType)) {
            return null;
        }
        if (JsonValue.ValueType.STRING.equals((Object)valueType)) {
            if (key.getTo() == JsonString.class) {
                return converter.to(JsonString.class.cast(jsonValue));
            }
            return converter.to(((JsonString)JsonString.class.cast(jsonValue)).getString());
        }
        if ((JsonValue.ValueType.TRUE.equals((Object)valueType) || JsonValue.ValueType.FALSE.equals((Object)valueType)) && key != null && (Boolean.TYPE == key.getTo() || Boolean.class == key.getTo())) {
            return converter.to(Boolean.parseBoolean(jsonValue.toString()));
        }
        if (JsonValue.ValueType.NUMBER.equals((Object)valueType) && key != null) {
            if (Long.class == key.getTo() || Long.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).longValue());
            }
            if (Integer.class == key.getTo() || Integer.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).intValue());
            }
            if (Double.class == key.getTo() || Double.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).doubleValue());
            }
            if (Float.class == key.getTo() || Float.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).doubleValue());
            }
            if (BigInteger.class == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).bigIntegerValue());
            }
            if (BigDecimal.class == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).bigDecimalValue());
            }
            if (JsonNumber.class == key.getTo()) {
                return converter.to(JsonNumber.class.cast(jsonValue));
            }
        }
        if (JsonValue.ValueType.ARRAY.equals((Object)valueType)) {
            if (JsonArray.class == key.getTo() || JsonStructure.class == key.getTo()) {
                return converter.to(jsonValue.asJsonObject());
            }
            return this.buildArray(key.getTo(), jsonValue.asJsonArray(), null, null, jsonPointer, null);
        }
        return converter.to(jsonValue.toString());
    }

    private AdapterKey getAdapterKey(Adapter converter) {
        AdapterKey adapterKey = (AdapterKey)this.config.getReverseAdapters().get(converter);
        if (adapterKey == null) {
            if (converter instanceof TypeAwareAdapter) {
                TypeAwareAdapter typeAwareAdapter = (TypeAwareAdapter)converter;
                adapterKey = new AdapterKey(typeAwareAdapter.getFrom(), typeAwareAdapter.getTo());
                this.config.getReverseAdapters().putIfAbsent(converter, adapterKey);
            } else {
                Type[] types;
                for (Type t : types = converter.getClass().getGenericInterfaces()) {
                    ParameterizedType pt;
                    if (!ParameterizedType.class.isInstance(t) || Adapter.class != (pt = (ParameterizedType)ParameterizedType.class.cast(t)).getRawType()) continue;
                    Type[] actualTypeArguments = pt.getActualTypeArguments();
                    adapterKey = new AdapterKey(actualTypeArguments[0], actualTypeArguments[1]);
                    this.config.getReverseAdapters().putIfAbsent(converter, adapterKey);
                    break;
                }
            }
        }
        return adapterKey;
    }

    private Object toObject(Object baseInstance, JsonValue jsonValue, Type type, Adapter itemConverter, JsonPointerTracker jsonPointer, Type rootType) {
        if (jsonValue == null) {
            return null;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (JsonValue.ValueType.NULL == valueType) {
            return null;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            if (JsonValue.ValueType.TRUE == valueType) {
                return true;
            }
            if (JsonValue.ValueType.FALSE == valueType) {
                return false;
            }
            throw new MapperException("Unable to parse " + jsonValue + " to boolean");
        }
        if (this.config.isTreatByteArrayAsBase64() && jsonValue.getValueType() == JsonValue.ValueType.STRING && type == byte[].class) {
            return Base64.getDecoder().decode(((JsonString)jsonValue).getString());
        }
        if (this.config.isTreatByteArrayAsBase64URL() && jsonValue.getValueType() == JsonValue.ValueType.STRING && type == byte[].class) {
            return Base64.getUrlDecoder().decode(((JsonString)jsonValue).getString());
        }
        if (Object.class == type) {
            if (JsonValue.ValueType.TRUE == valueType) {
                return true;
            }
            if (JsonValue.ValueType.FALSE == valueType) {
                return false;
            }
            if (JsonNumber.class.isInstance(jsonValue)) {
                return this.toNumberValue((JsonNumber)JsonNumber.class.cast(jsonValue));
            }
        }
        if (type == Character.class || type == Character.TYPE) {
            return this.convertTo((Type)Class.class.cast(type), ((JsonString)JsonString.class.cast(jsonValue)).getString());
        }
        if (JsonObject.class.isInstance(jsonValue)) {
            if (JsonObject.class == type || JsonStructure.class == type) {
                return jsonValue;
            }
            boolean typedAdapter = TypeAwareAdapter.class.isInstance(itemConverter);
            Object object = this.buildObject(baseInstance != null ? baseInstance.getClass() : (typedAdapter ? ((TypeAwareAdapter)TypeAwareAdapter.class.cast(itemConverter)).getTo() : type), (JsonObject)JsonObject.class.cast(jsonValue), type instanceof Class, jsonPointer);
            return typedAdapter ? itemConverter.to(object) : object;
        }
        if (JsonArray.class.isInstance(jsonValue)) {
            if (JsonArray.class == type || JsonStructure.class == type) {
                return jsonValue;
            }
            return this.buildArray(type, (JsonArray)JsonArray.class.cast(jsonValue), itemConverter, null, jsonPointer, rootType);
        }
        if (JsonNumber.class.isInstance(jsonValue)) {
            if (JsonNumber.class == type) {
                return jsonValue;
            }
            JsonNumber number = (JsonNumber)JsonNumber.class.cast(jsonValue);
            if (type == Long.class || type == Long.TYPE) {
                return number.longValueExact();
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf((float)number.doubleValue());
            }
            if (type == Double.class || type == Double.TYPE) {
                return number.doubleValue();
            }
            if (type == BigInteger.class) {
                return number.bigIntegerValue();
            }
            if (type == BigDecimal.class) {
                return number.bigDecimalValue();
            }
            int intValue = number.intValueExact();
            if (type == Integer.class || type == Integer.TYPE) {
                return intValue;
            }
            if (type == Short.class || type == Short.TYPE) {
                short shortVal = (short)intValue;
                if (intValue != shortVal) {
                    throw new ArithmeticException("Overflow");
                }
                return shortVal;
            }
            if (type == Byte.class || type == Byte.TYPE) {
                if (intValue < -128 || intValue > 255) {
                    throw new ArithmeticException("Overflow");
                }
                return (byte)intValue;
            }
        } else if (JsonString.class.isInstance(jsonValue)) {
            if (JsonString.class == type) {
                return jsonValue;
            }
            String string = ((JsonString)JsonString.class.cast(jsonValue)).getString();
            if (itemConverter == null) {
                Object o;
                if (!String.class.equals((Object)type) && (o = this.jsonPointers.get(string)) != null) {
                    return o;
                }
                return this.convertTo(type, string);
            }
            return itemConverter.to(string);
        }
        throw new MapperException("Unable to parse " + jsonValue + " to " + type);
    }

    private Object buildArray(Type type, JsonArray jsonArray, Adapter itemConverter, ObjectConverter.Reader objectConverter, JsonPointerTracker jsonPointer, Type rootType) {
        Mappings.CollectionMapping mapping;
        Class clazz;
        if (Class.class.isInstance(type) && (clazz = (Class)Class.class.cast(type)).isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return this.buildArrayWithComponentType(jsonArray, componentType, itemConverter, jsonPointer, rootType);
        }
        if (ParameterizedType.class.isInstance(type) && (mapping = this.mappings.findCollectionMapping((ParameterizedType)ParameterizedType.class.cast(type), rootType)) != null) {
            return this.mapCollection(mapping, jsonArray, itemConverter, objectConverter, jsonPointer, rootType);
        }
        if (Object.class == type) {
            return this.buildArray(ANY_LIST, jsonArray, null, null, jsonPointer, rootType);
        }
        throw new UnsupportedOperationException("type " + type + " not supported");
    }

    private Object buildArrayWithComponentType(JsonArray jsonArray, Class<?> componentType, Adapter itemConverter, JsonPointerTracker jsonPointer, Type rootType) {
        if (Boolean.TYPE == componentType) {
            boolean[] array = new boolean[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Boolean)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Byte.TYPE == componentType) {
            byte[] array = new byte[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Byte)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Character.TYPE == componentType) {
            char[] array = new char[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = ((Character)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType)).charValue();
                ++i;
            }
            return array;
        }
        if (Short.TYPE == componentType) {
            short[] array = new short[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Short)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Integer.TYPE == componentType) {
            int[] array = new int[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Integer)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Long.TYPE == componentType) {
            long[] array = new long[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Long)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Float.TYPE == componentType) {
            float[] array = new float[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = ((Float)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType)).floatValue();
                ++i;
            }
            return array;
        }
        if (Double.TYPE == componentType) {
            double[] array = new double[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Double)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Boolean.class == componentType) {
            Boolean[] array = new Boolean[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Boolean)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Byte.class == componentType) {
            Byte[] array = new Byte[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Byte)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Character.class == componentType) {
            Character[] array = new Character[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Character)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Short.class == componentType) {
            Short[] array = new Short[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Short)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Integer.class == componentType) {
            Integer[] array = new Integer[jsonArray.size()];
            Integer i = 0;
            for (JsonValue value : jsonArray) {
                array[i.intValue()] = (Integer)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return array;
        }
        if (Long.class == componentType) {
            Long[] array = new Long[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Long)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Float.class == componentType) {
            Float[] array = new Float[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Float)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Double.class == componentType) {
            Double[] array = new Double[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Double)this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        Object array = Array.newInstance(componentType, jsonArray.size());
        int i = 0;
        for (JsonValue value : jsonArray) {
            Array.set(array, i, this.toObject(null, value, componentType, itemConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType));
            ++i;
        }
        return array;
    }

    private <T> Collection<T> mapCollection(Mappings.CollectionMapping mapping, JsonArray jsonArray, Adapter itemConverter, ObjectConverter.Reader objectConverter, JsonPointerTracker jsonPointer, Type rootType) {
        AbstractCollection collection;
        if (SortedSet.class == mapping.raw || NavigableSet.class == mapping.raw || TreeSet.class == mapping.raw) {
            collection = new TreeSet();
        } else if (Set.class == mapping.raw || HashSet.class == mapping.raw) {
            collection = new HashSet(jsonArray.size());
        } else if (Queue.class == mapping.raw || ArrayBlockingQueue.class == mapping.raw) {
            collection = new ArrayBlockingQueue(jsonArray.size());
        } else if (List.class == mapping.raw || Collection.class == mapping.raw || ArrayList.class == mapping.raw || EnumSet.class == mapping.raw) {
            collection = new ArrayList(jsonArray.size());
        } else if (LinkedHashSet.class == mapping.raw) {
            collection = new LinkedHashSet(jsonArray.size());
        } else if (Deque.class == mapping.raw || ArrayDeque.class == mapping.raw) {
            collection = new ArrayDeque(jsonArray.size());
        } else if (Queue.class == mapping.raw || PriorityQueue.class == mapping.raw) {
            collection = new PriorityQueue(jsonArray.size());
        } else {
            throw new IllegalStateException("not supported collection type: " + mapping.raw.getName());
        }
        int i = 0;
        for (JsonValue value : jsonArray) {
            collection.add(JsonValue.NULL.equals(value) ? null : this.toValue(null, value, null, itemConverter, mapping.arg, objectConverter, this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, i) : null, rootType));
            ++i;
        }
        if (EnumSet.class == mapping.raw) {
            if (collection.isEmpty()) {
                return EnumSet.noneOf((Class)Class.class.cast(mapping.arg));
            }
            if (collection.size() == 1) {
                return (Collection)Collection.class.cast(EnumSet.of((Enum)Enum.class.cast(collection.iterator().next())));
            }
            List list = (List)List.class.cast(collection);
            return (Collection)Collection.class.cast(EnumSet.of((Enum)list.get(0), list.subList(1, list.size()).toArray(new Enum[list.size() - 1])));
        }
        return collection;
    }

    private Object[] createParameters(Mappings.ClassMapping mapping, JsonObject object, JsonPointerTracker jsonPointer) {
        int length = mapping.factory.getParameterTypes().length;
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            String paramName = mapping.factory.getParameterNames()[i];
            objects[i] = this.toValue(null, (JsonValue)object.get((Object)paramName), mapping.factory.getParameterConverter()[i], mapping.factory.getParameterItemConverter()[i], mapping.factory.getParameterTypes()[i], mapping.factory.getObjectConverter()[i], this.isDeduplicateObjects ? new JsonPointerTracker(jsonPointer, paramName) : null, mapping.clazz);
        }
        return objects;
    }

    private Object toValue(Object baseInstance, JsonValue jsonValue, Adapter converter, Adapter itemConverter, Type type, ObjectConverter.Reader objectConverter, JsonPointerTracker jsonPointer, Type rootType) {
        if (objectConverter != null) {
            return objectConverter.fromJson(jsonValue, type, this);
        }
        try {
            return converter == null ? this.toObject(baseInstance, jsonValue, type, itemConverter, jsonPointer, rootType) : this.convertTo(converter, jsonValue, jsonPointer);
        }
        catch (Exception e) {
            if (e instanceof MapperException) {
                throw e;
            }
            throw new MapperException(e);
        }
    }

    private Object convertTo(Type aClass, String text) {
        if (Object.class == aClass || String.class == aClass) {
            return text;
        }
        Adapter converter = this.findAdapter(aClass);
        Method method = (Method)this.valueOfs.get(aClass);
        if (method == null && Class.class.isInstance(aClass)) {
            Class cast = (Class)Class.class.cast(aClass);
            try {
                method = cast.getMethod("valueOf", String.class);
                if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                    this.valueOfs.putIfAbsent(cast, method);
                } else {
                    method = null;
                }
            }
            catch (NoSuchMethodException e) {
                if (Character.TYPE == aClass) {
                    return CHARACTER_CONVERTER.fromString(text);
                }
                try {
                    return this.convertTo((Type)Class.class.cast(cast.getField("TYPE").get(null)), text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (method != null) {
            try {
                return method.invoke(null, text);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new MapperException(e.getCause());
            }
        }
        if (converter == null) {
            if (ParameterizedType.class.isInstance(aClass)) {
                return this.convertTo(((ParameterizedType)ParameterizedType.class.cast(aClass)).getRawType(), text);
            }
            throw new MapperException("Missing a Converter for type " + aClass + " to convert the JSON String '" + text + "' . Please register a custom converter for it.");
        }
        return converter.to(text);
    }

    private Adapter findAdapter(Type aClass) {
        Class clazz;
        Adapter converter = (Adapter)this.config.getAdapters().get(new AdapterKey(aClass, (Type)((Object)String.class)));
        if (converter != null) {
            return converter;
        }
        if (Class.class.isInstance(aClass) && (clazz = (Class)Class.class.cast(aClass)).isEnum()) {
            ConverterAdapter enumConverter = new ConverterAdapter(new EnumConverter(clazz));
            this.config.getAdapters().putIfAbsent(new AdapterKey((Type)((Object)String.class), aClass), enumConverter);
            return enumConverter;
        }
        return null;
    }

    private static class SuppressConversionMappingParser
    implements MappingParser {
        private final MappingParserImpl delegate;
        private final JsonObject suppressConversionFor;

        public SuppressConversionMappingParser(MappingParserImpl delegate, JsonObject suppressConversionFor) {
            this.delegate = delegate;
            this.suppressConversionFor = suppressConversionFor;
        }

        @Override
        public <T> T readObject(Type targetType) {
            return this.delegate.readObject(targetType);
        }

        @Override
        public <T> T readObject(JsonValue jsonValue, Type targetType) {
            if (this.suppressConversionFor == jsonValue) {
                return (T)this.delegate.readObject(jsonValue, targetType, false);
            }
            return this.delegate.readObject(jsonValue, targetType);
        }
    }
}

