/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider;

import com.vladsch.flexmark.util.html.MutableAttributes;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.NodeAttributeProviderState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;

public class ImageLinkAttributeProviderState
implements NodeAttributeProviderState<JSPWikiLink> {
    private final boolean isLinkFromText;
    private final LinkParsingOperations linkOperations;
    private final Context wikiContext;
    private final String urlRef;

    public ImageLinkAttributeProviderState(Context wikiContext, String urlRef, boolean isLinkFromText) {
        this.isLinkFromText = isLinkFromText;
        this.urlRef = urlRef;
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
    }

    @Override
    public void setAttributes(MutableAttributes attributes, JSPWikiLink link) {
        if (this.isLinkFromText && this.linkOperations.isExternalLink(link.getText().toString())) {
            attributes.replaceValue((CharSequence)"class", (CharSequence)"external");
            attributes.replaceValue((CharSequence)"href", (CharSequence)this.urlRef);
        } else if (this.isLinkFromText && this.linkOperations.linkExists(link.getText().toString())) {
            String pagelink = this.wikiContext.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), link.getText().toString());
            attributes.replaceValue((CharSequence)"class", (CharSequence)"wikipage");
            attributes.replaceValue((CharSequence)"href", (CharSequence)pagelink);
        }
    }
}

