/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Acl;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorStateCommonOperations;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.render.RenderingManager;

public class AccessRuleLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private static final Logger LOG = LogManager.getLogger(AccessRuleLinkNodePostProcessorState.class);
    private final Context wikiContext;
    private final boolean m_wysiwygEditorMode;

    public AccessRuleLinkNodePostProcessorState(Context wikiContext) {
        this.wikiContext = wikiContext;
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        this.m_wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
    }

    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        String ruleLine = NodePostProcessorStateCommonOperations.inlineLinkTextOnWysiwyg(state, link, this.m_wysiwygEditorMode);
        if (((RenderingManager)this.wikiContext.getEngine().getManager(RenderingManager.class)).getParser(this.wikiContext, link.getUrl().toString()).isParseAccessRules()) {
            Page page = this.wikiContext.getRealPage();
            if (ruleLine.startsWith("{")) {
                ruleLine = ruleLine.substring(1);
            }
            if (ruleLine.endsWith("}")) {
                ruleLine = ruleLine.substring(0, ruleLine.length() - 1);
            }
            LOG.debug("page=" + page.getName() + ", ACL = " + ruleLine);
            try {
                Acl acl = ((AclManager)this.wikiContext.getEngine().getManager(AclManager.class)).parseAcl(page, ruleLine);
                page.setAcl(acl);
                link.unlink();
                state.nodeRemoved((Node)link);
                LOG.debug(acl.toString());
            }
            catch (WikiSecurityException wse) {
                NodePostProcessorStateCommonOperations.makeError(state, (Node)link, wse.getMessage());
            }
        }
    }
}

