/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.juneau.doc.internal.Console;

public class DocStore {
    private Map<String, Link> mappings = new TreeMap<String, Link>();

    public DocStore(File f) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Scanner s = new Scanner(f);){
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    int i = line.indexOf(61);
                    if (i == -1) continue;
                    this.mappings.put(line.substring(0, i).trim(), new Link(line.substring(i + 1)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addLink(String key, String href, String text) {
        if (this.mappings.containsKey(key)) {
            this.mappings.remove(key);
            Console.warning(null, "Duplicate @doc tag: {0}", key);
            return;
        }
        this.mappings.put(key, new Link(href, text));
    }

    public Link getLink(String key) {
        return this.mappings.get(key);
    }

    public void save(File f) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter fw = new FileWriter(f);){
                for (Map.Entry<String, Link> e : this.mappings.entrySet()) {
                    Link l = e.getValue();
                    fw.append(e.getKey()).append(" = ").append(l.href).append(", ").append(l.label).append('\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Link {
        public String href;
        public String label;

        public Link(String s) {
            int i = s.indexOf(44);
            if (i != -1) {
                this.href = s.substring(0, i).trim();
                this.label = s.substring(i + 1).trim();
            } else {
                this.href = s;
                i = s.lastIndexOf(47);
                this.label = s.substring(i + 1).trim();
            }
        }

        public Link(String href, String text) {
            this.href = href;
            this.label = text;
        }
    }
}

