/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorOffset;

public class ConnectorOffsets {
    private final List<ConnectorOffset> offsets;

    @JsonCreator
    public ConnectorOffsets(@JsonProperty(value="offsets") List<ConnectorOffset> offsets) {
        this.offsets = offsets;
    }

    @JsonProperty
    public List<ConnectorOffset> offsets() {
        return this.offsets;
    }

    public Map<Map<String, ?>, Map<String, ?>> toMap() {
        HashMap partitionOffsetMap = new HashMap();
        for (ConnectorOffset offset : this.offsets) {
            partitionOffsetMap.put(offset.partition(), offset.offset());
        }
        return partitionOffsetMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectorOffsets)) {
            return false;
        }
        ConnectorOffsets that = (ConnectorOffsets)obj;
        return Objects.equals(this.offsets, that.offsets);
    }

    public int hashCode() {
        return Objects.hashCode(this.offsets);
    }
}

