/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class QuorumControllerMetrics
implements AutoCloseable {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveControllerCount");
    private static final MetricName EVENT_QUEUE_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueTimeMs");
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueProcessingTimeMs");
    private static final MetricName ZK_WRITE_BEHIND_LAG = QuorumControllerMetrics.getMetricName("KafkaController", "ZkWriteBehindLag");
    private static final MetricName ZK_WRITE_SNAPSHOT_TIME_MS = QuorumControllerMetrics.getMetricName("KafkaController", "ZkWriteSnapshotTimeMs");
    private static final MetricName ZK_WRITE_DELTA_TIME_MS = QuorumControllerMetrics.getMetricName("KafkaController", "ZkWriteDeltaTimeMs");
    private static final MetricName LAST_APPLIED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordOffset");
    private static final MetricName LAST_COMMITTED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastCommittedRecordOffset");
    private static final MetricName LAST_APPLIED_RECORD_TIMESTAMP = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordTimestamp");
    private static final MetricName LAST_APPLIED_RECORD_LAG_MS = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordLagMs");
    private static final MetricName TIMED_OUT_BROKER_HEARTBEAT_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "TimedOutBrokerHeartbeatCount");
    private static final MetricName EVENT_QUEUE_OPERATIONS_STARTED_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "EventQueueOperationsStartedCount");
    private static final MetricName EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "EventQueueOperationsTimedOutCount");
    private static final MetricName NEW_ACTIVE_CONTROLLERS_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "NewActiveControllersCount");
    private final Optional<MetricsRegistry> registry;
    private volatile boolean active;
    private final AtomicLong lastAppliedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastCommittedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastAppliedRecordTimestamp = new AtomicLong(0L);
    private final AtomicLong dualWriteOffset = new AtomicLong(0L);
    private final Consumer<Long> eventQueueTimeUpdater;
    private final Consumer<Long> eventQueueProcessingTimeUpdater;
    private final Consumer<Long> zkWriteSnapshotTimeHandler;
    private final Consumer<Long> zkWriteDeltaTimeHandler;
    private final AtomicLong timedOutHeartbeats = new AtomicLong(0L);
    private final AtomicLong operationsStarted = new AtomicLong(0L);
    private final AtomicLong operationsTimedOut = new AtomicLong(0L);
    private final AtomicLong newActiveControllers = new AtomicLong(0L);

    private Consumer<Long> newHistogram(MetricName name, boolean biased) {
        if (this.registry.isPresent()) {
            Histogram histogram = this.registry.get().newHistogram(name, biased);
            return e -> histogram.update(e.longValue());
        }
        return __ -> {};
    }

    public QuorumControllerMetrics(Optional<MetricsRegistry> registry, final Time time, boolean zkMigrationEnabled) {
        this.registry = registry;
        this.active = false;
        registry.ifPresent(r -> r.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        }));
        this.eventQueueTimeUpdater = this.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTimeUpdater = this.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_COMMITTED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastCommittedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_TIMESTAMP, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordTimestamp();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_LAG_MS, (Gauge)new Gauge<Long>(){

            public Long value() {
                return time.milliseconds() - QuorumControllerMetrics.this.lastAppliedRecordTimestamp();
            }
        }));
        registry.ifPresent(r -> r.newGauge(TIMED_OUT_BROKER_HEARTBEAT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.timedOutHeartbeats();
            }
        }));
        registry.ifPresent(r -> r.newGauge(EVENT_QUEUE_OPERATIONS_STARTED_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.operationsStarted();
            }
        }));
        registry.ifPresent(r -> r.newGauge(EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.operationsTimedOut();
            }
        }));
        registry.ifPresent(r -> r.newGauge(NEW_ACTIVE_CONTROLLERS_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.newActiveControllers();
            }
        }));
        if (zkMigrationEnabled) {
            registry.ifPresent(r -> r.newGauge(ZK_WRITE_BEHIND_LAG, (Gauge)new Gauge<Long>(){

                public Long value() {
                    if (QuorumControllerMetrics.this.dualWriteOffset() == 0L || !QuorumControllerMetrics.this.active()) {
                        return 0L;
                    }
                    return QuorumControllerMetrics.this.lastCommittedRecordOffset() - QuorumControllerMetrics.this.dualWriteOffset();
                }
            }));
            this.zkWriteSnapshotTimeHandler = this.newHistogram(ZK_WRITE_SNAPSHOT_TIME_MS, true);
            this.zkWriteDeltaTimeHandler = this.newHistogram(ZK_WRITE_DELTA_TIME_MS, true);
        } else {
            this.zkWriteSnapshotTimeHandler = __ -> {};
            this.zkWriteDeltaTimeHandler = __ -> {};
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean active() {
        return this.active;
    }

    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTimeUpdater.accept(durationMs);
    }

    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTimeUpdater.accept(durationMs);
    }

    public void updateZkWriteSnapshotTimeMs(long durationMs) {
        this.zkWriteSnapshotTimeHandler.accept(durationMs);
    }

    public void updateZkWriteDeltaTimeMs(long durationMs) {
        this.zkWriteDeltaTimeHandler.accept(durationMs);
    }

    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset.set(offset);
    }

    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset.get();
    }

    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset.set(offset);
    }

    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset.get();
    }

    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp.set(timestamp);
    }

    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp.get();
    }

    public void updateDualWriteOffset(long offset) {
        this.dualWriteOffset.set(offset);
    }

    public long dualWriteOffset() {
        return this.dualWriteOffset.get();
    }

    public void incrementTimedOutHeartbeats() {
        this.timedOutHeartbeats.incrementAndGet();
    }

    public long timedOutHeartbeats() {
        return this.timedOutHeartbeats.get();
    }

    public void incrementOperationsStarted() {
        this.operationsStarted.incrementAndGet();
    }

    public long operationsStarted() {
        return this.operationsStarted.get();
    }

    public void incrementOperationsTimedOut() {
        this.operationsTimedOut.incrementAndGet();
    }

    public long operationsTimedOut() {
        return this.operationsTimedOut.get();
    }

    public void incrementNewActiveControllers() {
        this.newActiveControllers.incrementAndGet();
    }

    public long newActiveControllers() {
        return this.newActiveControllers.get();
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(ACTIVE_CONTROLLER_COUNT, EVENT_QUEUE_TIME_MS, EVENT_QUEUE_PROCESSING_TIME_MS, LAST_APPLIED_RECORD_OFFSET, LAST_COMMITTED_RECORD_OFFSET, LAST_APPLIED_RECORD_TIMESTAMP, LAST_APPLIED_RECORD_LAG_MS, TIMED_OUT_BROKER_HEARTBEAT_COUNT, EVENT_QUEUE_OPERATIONS_STARTED_COUNT, EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT, NEW_ACTIVE_CONTROLLERS_COUNT, ZK_WRITE_BEHIND_LAG, ZK_WRITE_SNAPSHOT_TIME_MS, ZK_WRITE_DELTA_TIME_MS).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }
}

