/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Locale;
import java.util.Objects;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ShareGroupAutoOffsetResetStrategy {
    public static final ShareGroupAutoOffsetResetStrategy EARLIEST = new ShareGroupAutoOffsetResetStrategy(AutoOffsetResetStrategy.EARLIEST, StrategyType.EARLIEST);
    public static final ShareGroupAutoOffsetResetStrategy LATEST = new ShareGroupAutoOffsetResetStrategy(AutoOffsetResetStrategy.LATEST, StrategyType.LATEST);
    private final AutoOffsetResetStrategy delegate;
    private final StrategyType type;

    private ShareGroupAutoOffsetResetStrategy(AutoOffsetResetStrategy delegate, StrategyType type) {
        this.delegate = delegate;
        this.type = type;
    }

    public static ShareGroupAutoOffsetResetStrategy fromString(String offsetStrategy) {
        AutoOffsetResetStrategy baseStrategy = AutoOffsetResetStrategy.fromString((String)offsetStrategy);
        AutoOffsetResetStrategy.StrategyType baseType = baseStrategy.type();
        return new ShareGroupAutoOffsetResetStrategy(baseStrategy, switch (baseType) {
            case AutoOffsetResetStrategy.StrategyType.EARLIEST -> StrategyType.EARLIEST;
            case AutoOffsetResetStrategy.StrategyType.LATEST -> StrategyType.LATEST;
            case AutoOffsetResetStrategy.StrategyType.BY_DURATION -> StrategyType.BY_DURATION;
            default -> throw new IllegalArgumentException("Unsupported strategy for ShareGroup: " + String.valueOf(baseType));
        });
    }

    public StrategyType type() {
        return this.type;
    }

    public String name() {
        return this.type.toString();
    }

    public Long timestamp() {
        return (Long)this.delegate.timestamp().get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareGroupAutoOffsetResetStrategy that = (ShareGroupAutoOffsetResetStrategy)o;
        return this.type == that.type && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delegate, this.type});
    }

    public String toString() {
        return "ShareGroupAutoOffsetResetStrategy{type=" + String.valueOf((Object)this.type) + ", delegate=" + String.valueOf(this.delegate) + "}";
    }

    public static ShareGroupAutoOffsetResetStrategy earliest() {
        return new ShareGroupAutoOffsetResetStrategy(AutoOffsetResetStrategy.EARLIEST, StrategyType.EARLIEST);
    }

    public static ShareGroupAutoOffsetResetStrategy latest() {
        return new ShareGroupAutoOffsetResetStrategy(AutoOffsetResetStrategy.LATEST, StrategyType.LATEST);
    }

    public static enum StrategyType {
        LATEST,
        EARLIEST,
        BY_DURATION;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static class Validator
    implements ConfigDef.Validator {
        public void ensureValid(String name, Object value) {
            String offsetStrategy = (String)value;
            try {
                ShareGroupAutoOffsetResetStrategy.fromString(offsetStrategy);
            }
            catch (Exception e) {
                throw new ConfigException(name, value, "Invalid value `" + offsetStrategy + "` for configuration " + name + ". The value must be either 'earliest', 'latest' or of the format 'by_duration:<PnDTnHnMn.nS.>'.");
            }
        }

        public String toString() {
            return "[earliest, latest, by_duration:PnDTnHnMn.nS]";
        }
    }
}

