/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="config", name="delete", description="Delete a configuration.")
public class DeleteCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="pid", description="PID of the configuration", required=true, multiValued=false)
    String pid;
    @Option(name="--force", aliases={}, description="Force the edition of this config, even if another one was under edition", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        String oldPid = (String)this.session.get("ConfigCommand.PID");
        if (oldPid != null && oldPid.equals(this.pid) && !this.force) {
            System.err.println("This config is being edited.  Cancel / update first, or use the --force option");
            return null;
        }
        this.configRepository.delete(this.pid);
        if (oldPid != null && oldPid.equals(this.pid) && !this.force) {
            this.session.put("ConfigCommand.PID", null);
            this.session.put("ConfigCommand.Props", null);
        }
        return null;
    }
}

