/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.apache.felix.http.base.internal.context.ExtServletContext;

public class HttpSessionWrapper
implements HttpSession {
    private static final String PREFIX = "org.apache.felix.http.session.context.";
    private static final String ATTR_PREFIX = "org.apache.felix.http.session.context.attr.";
    private static final String ATTR_CREATED = "org.apache.felix.http.session.context.created.";
    private static final String ATTR_LAST_ACCESSED = "org.apache.felix.http.session.context.lastaccessed.";
    private static final String ATTR_MAX_INACTIVE = "org.apache.felix.http.session.context.maxinactive.";
    private final HttpSession delegate;
    private final ExtServletContext context;
    private final String sessionId;
    private final String keyPrefix;
    private volatile boolean isInvalid = false;
    private final long created;
    private final long lastAccessed;
    private int maxTimeout;
    private final boolean isNew;

    public static boolean hasSession(long contextId, HttpSession session) {
        String sessionId = String.valueOf(contextId);
        return session.getAttribute(ATTR_CREATED + sessionId) != null;
    }

    public static Set<Long> getExpiredSessionContextIds(HttpSession session) {
        long now = System.currentTimeMillis();
        HashSet<Long> ids = new HashSet<Long>();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(ATTR_LAST_ACCESSED)) continue;
            String id = name.substring(ATTR_LAST_ACCESSED.length());
            long lastAccess = (Long)session.getAttribute(name);
            Integer maxTimeout = (Integer)session.getAttribute(ATTR_MAX_INACTIVE + id);
            if (maxTimeout <= 0 || lastAccess + (long)maxTimeout.intValue() >= now) continue;
            ids.add(Long.valueOf(id));
        }
        return ids;
    }

    public static Set<Long> getSessionContextIds(HttpSession session) {
        HashSet<Long> ids = new HashSet<Long>();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(ATTR_LAST_ACCESSED)) continue;
            String id = name.substring(ATTR_LAST_ACCESSED.length());
            ids.add(Long.valueOf(id));
        }
        return ids;
    }

    public HttpSessionWrapper(long contextId, HttpSession session, ExtServletContext context, boolean terminate) {
        this.delegate = session;
        this.context = context;
        this.sessionId = String.valueOf(contextId);
        this.keyPrefix = ATTR_PREFIX + this.sessionId + ".";
        if (this.keyPrefix != null) {
            long now = System.currentTimeMillis();
            if (session.getAttribute(ATTR_CREATED + this.sessionId) == null) {
                this.created = now;
                this.maxTimeout = session.getMaxInactiveInterval();
                this.isNew = true;
                session.setAttribute(ATTR_CREATED + this.sessionId, (Object)this.created);
                session.setAttribute(ATTR_MAX_INACTIVE + this.sessionId, (Object)this.maxTimeout);
                if (context.getHttpSessionListener() != null) {
                    context.getHttpSessionListener().sessionCreated(new HttpSessionEvent((HttpSession)this));
                }
            } else {
                this.created = (Long)session.getAttribute(ATTR_CREATED + this.sessionId);
                this.maxTimeout = (Integer)session.getAttribute(ATTR_MAX_INACTIVE + this.sessionId);
                this.isNew = false;
            }
            this.lastAccessed = now;
            if (!terminate) {
                session.setAttribute(ATTR_LAST_ACCESSED + this.sessionId, (Object)this.lastAccessed);
            }
        } else {
            this.isNew = session.isNew();
            this.lastAccessed = session.getLastAccessedTime();
            this.created = session.getCreationTime();
        }
    }

    private String getKey(String name) {
        return this.keyPrefix == null ? name : this.keyPrefix.concat(name);
    }

    private void checkInvalid() {
        if (this.isInvalid) {
            throw new IllegalStateException("Session is invalid.");
        }
    }

    public Object getAttribute(String name) {
        this.checkInvalid();
        Object result = this.delegate.getAttribute(this.getKey(name));
        if (result instanceof SessionBindingValueListenerWrapper) {
            result = ((SessionBindingValueListenerWrapper)result).getHttpSessionBindingListener();
        }
        return result;
    }

    public Enumeration<String> getAttributeNames() {
        this.checkInvalid();
        final Enumeration e = this.delegate.getAttributeNames();
        return new Enumeration<String>(){
            String next = this.peek();

            private String peek() {
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (HttpSessionWrapper.this.keyPrefix == null && !name.startsWith(HttpSessionWrapper.PREFIX)) {
                        return name;
                    }
                    if (!name.startsWith(HttpSessionWrapper.this.keyPrefix)) continue;
                    return name.substring(HttpSessionWrapper.this.keyPrefix.length());
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public String nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                String result = this.next;
                this.next = this.peek();
                return result;
            }
        };
    }

    public long getCreationTime() {
        this.checkInvalid();
        return this.created;
    }

    public String getId() {
        this.checkInvalid();
        return this.delegate.getId() + "-" + this.sessionId;
    }

    public long getLastAccessedTime() {
        this.checkInvalid();
        return this.lastAccessed;
    }

    public int getMaxInactiveInterval() {
        return this.maxTimeout;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        return names.toArray(new String[names.size()]);
    }

    public void invalidate() {
        Enumeration names;
        this.checkInvalid();
        if (this.keyPrefix != null) {
            this.delegate.removeAttribute(ATTR_CREATED + this.sessionId);
            this.delegate.removeAttribute(ATTR_LAST_ACCESSED + this.sessionId);
            this.delegate.removeAttribute(ATTR_MAX_INACTIVE + this.sessionId);
            names = this.delegate.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(this.keyPrefix)) continue;
                this.removeAttribute(name.substring(this.keyPrefix.length()));
            }
        }
        if (!(names = this.delegate.getAttributeNames()).hasMoreElements()) {
            this.delegate.invalidate();
        }
        if (this.context.getHttpSessionListener() != null) {
            this.context.getHttpSessionListener().sessionDestroyed(new HttpSessionEvent((HttpSession)this));
        }
        this.isInvalid = true;
    }

    public boolean isNew() {
        this.checkInvalid();
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkInvalid();
        Object oldValue = this.getAttribute(name);
        if (oldValue != null) {
            this.delegate.removeAttribute(this.getKey(name));
            if (this.keyPrefix != null && oldValue instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            if (this.context.getHttpSessionAttributeListener() != null) {
                this.context.getHttpSessionAttributeListener().attributeRemoved(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
            }
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkInvalid();
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = this.getAttribute(name);
        if (this.keyPrefix != null && value instanceof HttpSessionBindingListener) {
            this.delegate.setAttribute(this.getKey(name), (Object)new SessionBindingValueListenerWrapper((HttpSessionBindingListener)value));
        } else {
            this.delegate.setAttribute(this.getKey(name), value);
        }
        if (this.keyPrefix != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        if (this.context.getHttpSessionAttributeListener() != null) {
            if (oldValue != null) {
                this.context.getHttpSessionAttributeListener().attributeReplaced(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
            } else {
                this.context.getHttpSessionAttributeListener().attributeAdded(new HttpSessionBindingEvent((HttpSession)this, name, value));
            }
        }
    }

    public void setMaxInactiveInterval(int interval) {
        if (this.delegate.getMaxInactiveInterval() < interval) {
            this.delegate.setMaxInactiveInterval(interval);
        }
        if (this.keyPrefix != null) {
            this.maxTimeout = interval;
            this.delegate.setAttribute(ATTR_MAX_INACTIVE + this.sessionId, (Object)interval);
        }
    }

    public HttpSessionContext getSessionContext() {
        return this.delegate.getSessionContext();
    }

    private static final class SessionBindingValueListenerWrapper
    implements Serializable {
        private static final long serialVersionUID = 4009563108883768425L;
        private final HttpSessionBindingListener listener;

        public SessionBindingValueListenerWrapper(HttpSessionBindingListener listener) {
            this.listener = listener;
        }

        public HttpSessionBindingListener getHttpSessionBindingListener() {
            return this.listener;
        }
    }
}

