/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.HttpServiceFilterHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.service.DefaultHttpContext;
import org.apache.felix.http.base.internal.service.ResourceServlet;
import org.apache.felix.http.base.internal.service.ServletContextManager;
import org.apache.felix.http.base.internal.service.SharedHttpServiceImpl;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public final class PerBundleHttpServiceImpl
implements ExtHttpService {
    private final Bundle bundle;
    private final Set<Servlet> localServlets = new HashSet<Servlet>();
    private final Set<FilterHandler> localFilters = new HashSet<FilterHandler>();
    private final ServletContextManager contextManager;
    private final SharedHttpServiceImpl sharedHttpService;

    public PerBundleHttpServiceImpl(Bundle bundle, SharedHttpServiceImpl sharedHttpService, ServletContext context, ServletContextAttributeListener servletAttributeListener, boolean sharedContextAttributes, ServletRequestListener reqListener, ServletRequestAttributeListener reqAttrListener) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        this.bundle = bundle;
        this.contextManager = new ServletContextManager(this.bundle, context, servletAttributeListener, sharedContextAttributes, reqListener, reqAttrListener, sharedHttpService.getHandlerRegistry().getRegistry(-1L));
        this.sharedHttpService = sharedHttpService;
    }

    @Override
    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFilter(Filter filter, String pattern, Dictionary initParams, int ranking, HttpContext context) throws ServletException {
        FilterInfo filterInfo;
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (initParams != null && initParams.size() > 0) {
            Enumeration e = initParams.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = initParams.get(key);
                if (!(key instanceof String) || !(value instanceof String)) continue;
                paramMap.put((String)key, (String)value);
            }
        }
        if (!(filterInfo = new FilterInfo(String.format("%s_%d", filter.getClass(), this.hashCode()), pattern, ranking, paramMap)).isValid()) {
            throw new ServletException("Invalid registration information for filter.");
        }
        ExtServletContext httpContext = this.getServletContext(context);
        HttpServiceFilterHandler holder = new HttpServiceFilterHandler(httpContext, filterInfo, filter);
        if (this.sharedHttpService.registerFilter(holder)) {
            Set<FilterHandler> set = this.localFilters;
            synchronized (set) {
                this.localFilters.add(holder);
            }
        }
    }

    @Override
    public void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        if (!this.isNameValid(name)) {
            throw new IllegalArgumentException("Malformed resource name [" + name + "]");
        }
        if (!PatternUtil.isValidPattern(alias) || !alias.startsWith("/")) {
            throw new IllegalArgumentException("Malformed resource alias [" + alias + "]");
        }
        try {
            ResourceServlet servlet = new ResourceServlet(name);
            this.registerServlet(alias, (Servlet)servlet, null, context);
        }
        catch (ServletException e) {
            SystemLogger.error("Failed to register resources", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext context) throws ServletException, NamespaceException {
        Object e;
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet must not be null");
        }
        if (!PatternUtil.isValidPattern(alias) || !alias.startsWith("/")) {
            throw new IllegalArgumentException("Malformed servlet alias [" + alias + "]");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (initParams != null && initParams.size() > 0) {
            e = initParams.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = initParams.get(key);
                if (!(key instanceof String) || !(value instanceof String)) continue;
                paramMap.put((String)key, (String)value);
            }
        }
        e = this.localServlets;
        synchronized (e) {
            if (this.localServlets.contains(servlet)) {
                throw new ServletException("Servlet instance " + servlet + " already registered");
            }
            this.localServlets.add(servlet);
        }
        ServletInfo servletInfo = new ServletInfo(String.format("%s_%d", servlet.getClass(), this.hashCode()), alias, paramMap);
        ExtServletContext httpContext = this.getServletContext(context);
        boolean success = false;
        try {
            this.sharedHttpService.registerServlet(alias, httpContext, servlet, servletInfo);
            success = true;
        }
        finally {
            if (!success) {
                Set<Servlet> set = this.localServlets;
                synchronized (set) {
                    this.localServlets.remove(servlet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String alias) {
        Servlet servlet = this.sharedHttpService.unregister(alias);
        if (servlet != null) {
            Set<Servlet> set = this.localServlets;
            synchronized (set) {
                this.localServlets.remove(servlet);
            }
        }
    }

    public void unregisterAll() {
        HashSet<Servlet> servlets = new HashSet<Servlet>(this.localServlets);
        for (Servlet servlet : servlets) {
            this.unregisterServlet(servlet, false);
        }
        HashSet<FilterHandler> filters = new HashSet<FilterHandler>(this.localFilters);
        for (FilterHandler holder : filters) {
            this.sharedHttpService.unregisterFilter(holder, false);
        }
    }

    @Override
    public void unregisterFilter(Filter filter) {
        this.unregisterFilter(filter, true);
    }

    @Override
    public void unregisterServlet(Servlet servlet) {
        this.unregisterServlet(servlet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServlet(Servlet servlet, boolean destroy) {
        if (servlet != null) {
            Set<Servlet> set = this.localServlets;
            synchronized (set) {
                this.localServlets.remove(servlet);
            }
            this.sharedHttpService.unregisterServlet(servlet, destroy);
        }
    }

    public ExtServletContext getServletContext(HttpContext context) {
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        return this.contextManager.getServletContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFilter(Filter filter, boolean destroy) {
        if (filter != null) {
            Set<FilterHandler> set = this.localFilters;
            synchronized (set) {
                Iterator<FilterHandler> i = this.localFilters.iterator();
                while (i.hasNext()) {
                    FilterHandler h = i.next();
                    if (h.getFilter() != filter) continue;
                    this.sharedHttpService.unregisterFilter(h, destroy);
                    i.remove();
                    break;
                }
            }
        }
    }

    private boolean isNameValid(String name) {
        if (name == null) {
            return false;
        }
        return name.equals("/") || !name.endsWith("/");
    }
}

