/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.spi.ThrowableRenderer;
import org.ops4j.pax.logging.util.OsgiUtil;
import org.osgi.framework.Bundle;

public final class OsgiThrowableRenderer
implements ThrowableRenderer {
    private SecurityManagerEx sm = new SecurityManagerEx();
    private static final Method classContextMethod;

    @Override
    public String[] doRender(Throwable throwable) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            HashSet<Throwable> dejavu = new HashSet<Throwable>();
            this.doRender(throwable, null, "", "", dejavu, lines);
            return lines.toArray(new String[lines.size()]);
        }
        catch (Exception exception) {
            return DefaultThrowableRenderer.render(throwable);
        }
    }

    private void doRender(Throwable throwable, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu, List<String> lines) {
        block16: {
            if (dejaVu.contains(throwable)) {
                lines.add("\t[CIRCULAR REFERENCE:" + this + "]");
            } else {
                int i;
                Class[] classCtx;
                dejaVu.add(throwable);
                StackTraceElement[] trace = throwable.getStackTrace();
                int framesInCommon = 0;
                int m = trace.length - 1;
                if (enclosingTrace != null) {
                    for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
                    }
                    framesInCommon = trace.length - 1 - m;
                }
                HashMap<String, String> classMap = new HashMap<String, String>();
                try {
                    classCtx = (Class[])classContextMethod.invoke((Object)throwable, new Object[0]);
                }
                catch (Throwable e) {
                    classCtx = this.sm.getClassContext();
                }
                Class lastClass = null;
                for (i = 0; i < trace.length && i < classCtx.length; ++i) {
                    Class clazz = classCtx[classCtx.length - 1 - i];
                    if (trace[trace.length - 1 - i].getClassName().equals(clazz.getName())) {
                        String classDetails = this.getClassDetail(clazz);
                        classMap.put(clazz.getName(), classDetails);
                        lastClass = clazz;
                        continue;
                    }
                    if (lastClass == null) break;
                    try {
                        ClassLoader cl = lastClass.getClassLoader();
                        if (cl == null) continue;
                        clazz = OsgiUtil.loadClass(cl, trace[trace.length - 1 - i].getClassName());
                        String classDetails = this.getClassDetail(clazz);
                        classMap.put(clazz.getName(), classDetails);
                        lastClass = clazz;
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                lines.add(prefix + caption + throwable);
                for (i = 0; i <= m; ++i) {
                    lines.add(prefix + this.formatElement(trace[i], classMap));
                }
                if (framesInCommon != 0) {
                    lines.add(prefix + "\t... " + framesInCommon + " more");
                }
                for (Throwable se : throwable.getSuppressed()) {
                    this.doRender(se, trace, "Suppressed: ", prefix + "\t", dejaVu, lines);
                }
                try {
                    Throwable[] causes;
                    for (Throwable cause : causes = (Throwable[])throwable.getClass().getMethod("getCauses", new Class[0]).invoke((Object)throwable, new Object[0])) {
                        this.doRender(cause, trace, "Caused by: ", prefix, dejaVu, lines);
                    }
                }
                catch (Throwable t) {
                    Throwable cause = throwable.getCause();
                    if (cause == null) break block16;
                    this.doRender(cause, trace, "Caused by: ", prefix, dejaVu, lines);
                }
            }
        }
    }

    private String formatElement(StackTraceElement element, Map<String, String> classMap) {
        StringBuilder buf = new StringBuilder("\tat ");
        buf.append(element);
        String className = element.getClassName();
        String classDetails = classMap.get(className);
        if (classDetails == null) {
            try {
                Class<?> cls = this.findClass(className);
                classDetails = this.getClassDetail(cls);
                classMap.put(className, classDetails);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (classDetails != null) {
            buf.append(classDetails);
        }
        return buf.toString();
    }

    private String getClassDetail(Class cls) {
        String implVersion;
        try {
            Bundle bundle = OsgiUtil.getBundleOrNull(cls);
            if (bundle != null) {
                StringBuilder buf = new StringBuilder();
                buf.append('[');
                buf.append(bundle.getBundleId());
                buf.append(":");
                buf.append(bundle.getSymbolicName());
                buf.append(":");
                buf.append(bundle.getVersion().toString());
                buf.append(']');
                return buf.toString();
            }
        }
        catch (Exception bundle) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        try {
            URL locationURL;
            CodeSource source = cls.getProtectionDomain().getCodeSource();
            if (source != null && (locationURL = source.getLocation()) != null) {
                if ("file".equals(locationURL.getProtocol())) {
                    String path = locationURL.getPath();
                    if (path != null) {
                        int lastSlash = path.lastIndexOf(47);
                        int lastBack = path.lastIndexOf(File.separatorChar);
                        if (lastBack > lastSlash) {
                            lastSlash = lastBack;
                        }
                        if (lastSlash <= 0 || lastSlash == path.length() - 1) {
                            buf.append(locationURL);
                        } else {
                            buf.append(path.substring(lastSlash + 1));
                        }
                    }
                } else {
                    buf.append(locationURL);
                }
            }
        }
        catch (SecurityException source) {
            // empty catch block
        }
        buf.append(':');
        Package pkg = cls.getPackage();
        if (pkg != null && (implVersion = pkg.getImplementationVersion()) != null) {
            buf.append(implVersion);
        }
        buf.append(']');
        return buf.toString();
    }

    private Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            return OsgiUtil.loadClass(Thread.currentThread().getContextClassLoader(), className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                return OsgiUtil.loadClass(this.getClass().getClassLoader(), className);
            }
        }
    }

    static {
        Method method;
        try {
            method = Exception.class.getDeclaredMethod("classContext", new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e1) {
            try {
                method = Exception.class.getMethod("getClassContext", new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                method = null;
            }
        }
        classContextMethod = method;
    }

    private static class SecurityManagerEx
    extends SecurityManager {
        private SecurityManagerEx() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

