/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileOrUriCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="cat", description="Displays the content of a file or URL.")
@Service
public class CatAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-n", aliases={}, description="Number the output lines, starting at 1.", required=false, multiValued=false)
    private boolean displayLineNumbers;
    @Option(name="-", description="Use stdin")
    private boolean stdin;
    @Argument(index=0, name="paths or urls", description="A list of file paths or urls to display separated by whitespace (use - for STDIN)", required=false, multiValued=true)
    @Completion(value=FileOrUriCompleter.class)
    private List<String> paths;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        if (this.stdin) {
            this.paths = Collections.singletonList("-");
        }
        if (this.paths == null) {
            throw new RuntimeException("Need to supply a path");
        }
        for (String filename : this.paths) {
            BufferedReader reader = new BufferedReader(this.createReader(filename));
            try {
                this.cat(reader);
            }
            finally {
                this.closeReader(reader);
            }
        }
        return null;
    }

    private void closeReader(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Reader createReader(String urlOrfileName) throws IOException, FileNotFoundException {
        if ("-".equals(urlOrfileName)) {
            this.log.debug("Printing STDIN");
            return new InputStreamReader(System.in);
        }
        try {
            URL url = new URL(urlOrfileName);
            this.log.debug("Printing URL: " + url);
            return new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException ignore) {
            File file = new File(urlOrfileName);
            this.log.debug("Printing file: " + file);
            return new FileReader(file);
        }
    }

    private void cat(BufferedReader reader) throws IOException {
        String line;
        int lineno = 1;
        while ((line = reader.readLine()) != null) {
            if (this.displayLineNumbers) {
                System.out.print(String.format("%6d  ", lineno++));
            }
            System.out.println(line);
        }
    }
}

