/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.tracker;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public final class SingleServiceTracker<T>
implements ServiceListener {
    private final BundleContext ctx;
    private final String className;
    private final AtomicReference<T> service = new AtomicReference();
    private final AtomicReference<ServiceReference> ref = new AtomicReference();
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final SingleServiceListener serviceListener;
    private final String filterString;
    private final Filter filter;

    public SingleServiceTracker(BundleContext context, Class<T> clazz, SingleServiceListener sl) throws InvalidSyntaxException {
        this(context, clazz, null, sl);
    }

    public SingleServiceTracker(BundleContext context, Class<T> clazz, String filterString, SingleServiceListener sl) throws InvalidSyntaxException {
        this(context, clazz.getName(), filterString, sl);
    }

    public SingleServiceTracker(BundleContext context, String className, String filterString, SingleServiceListener sl) throws InvalidSyntaxException {
        this.ctx = context;
        this.className = className;
        this.serviceListener = sl;
        if (filterString == null || filterString.isEmpty()) {
            this.filterString = null;
            this.filter = null;
        } else {
            this.filterString = filterString;
            this.filter = context.createFilter(filterString);
        }
    }

    public T getService() {
        return this.service.get();
    }

    public ServiceReference getServiceReference() {
        return this.ref.get();
    }

    public void open() {
        if (this.open.compareAndSet(false, true)) {
            try {
                String filterString = "(objectClass=" + this.className + ')';
                if (this.filter != null) {
                    filterString = "(&" + filterString + this.filter + ')';
                }
                this.ctx.addServiceListener((ServiceListener)this, filterString);
                this.findMatchingReference(null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.open.get()) {
            if (event.getType() == 4) {
                ServiceReference deadRef = event.getServiceReference();
                if (deadRef.equals(this.ref.get())) {
                    this.findMatchingReference(deadRef);
                }
            } else if (event.getType() == 1 && this.ref.get() == null) {
                this.findMatchingReference(null);
            }
        }
    }

    private void findMatchingReference(ServiceReference original) {
        try {
            boolean clear = true;
            Object[] refs = this.ctx.getServiceReferences(this.className, this.filterString);
            if (refs != null && refs.length > 0) {
                Object service;
                if (refs.length > 1) {
                    Arrays.sort(refs);
                }
                if ((service = this.ctx.getService((ServiceReference)refs[0])) != null) {
                    clear = false;
                    if (!this.update(original, (ServiceReference)refs[0], service)) {
                        this.ctx.ungetService((ServiceReference)refs[0]);
                    }
                }
            } else if (original == null) {
                clear = false;
            }
            if (clear) {
                this.update(original, null, null);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(ServiceReference deadRef, ServiceReference newRef, T service) {
        boolean result = false;
        int foundLostReplaced = -1;
        Object lock = newRef != null ? newRef : (deadRef != null ? deadRef : this);
        ServiceReference serviceReference = lock;
        synchronized (serviceReference) {
            if (this.open.get() && (result = this.ref.compareAndSet(deadRef, newRef))) {
                this.service.set(service);
                if (deadRef == null && newRef != null) {
                    foundLostReplaced = 0;
                }
                if (deadRef != null && newRef == null) {
                    foundLostReplaced = 1;
                }
                if (deadRef != null && newRef != null) {
                    foundLostReplaced = 2;
                }
            }
        }
        if (this.serviceListener != null) {
            if (foundLostReplaced == 0) {
                this.serviceListener.serviceFound();
            } else if (foundLostReplaced == 1) {
                this.serviceListener.serviceLost();
            } else if (foundLostReplaced == 2) {
                this.serviceListener.serviceReplaced();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            ServiceReference deadRef;
            this.ctx.removeServiceListener((ServiceListener)this);
            SingleServiceTracker singleServiceTracker = this;
            synchronized (singleServiceTracker) {
                deadRef = this.ref.getAndSet(null);
                this.service.set(null);
            }
            if (deadRef != null) {
                this.serviceListener.serviceLost();
                this.ctx.ungetService(deadRef);
            }
        }
    }

    public static interface SingleServiceListener {
        public void serviceFound();

        public void serviceLost();

        public void serviceReplaced();
    }
}

