/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.json;

import ch.qos.logback.contrib.json.JsonFormatter;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public abstract class JsonLayoutBase<E>
extends LayoutBase<E> {
    public static final String CONTENT_TYPE = "application/json";
    protected boolean includeTimestamp = true;
    protected String timestampFormat;
    protected String timestampFormatTimezoneId;
    protected boolean appendLineSeparator = false;
    protected JsonFormatter jsonFormatter;

    @Override
    public String doLayout(E event) {
        Map map = this.toJsonMap(event);
        if (map == null || map.isEmpty()) {
            return null;
        }
        String result = this.getStringFromFormatter(map);
        return this.isAppendLineSeparator() ? result + CoreConstants.LINE_SEPARATOR : result;
    }

    private String getStringFromFormatter(Map map) {
        JsonFormatter formatter = this.getJsonFormatter();
        if (formatter == null) {
            this.addError("JsonFormatter has not been configured on JsonLayout instance " + this.getClass().getName() + ".  Defaulting to map.toString().");
            return map.toString();
        }
        try {
            return formatter.toJsonString(map);
        }
        catch (Exception e) {
            this.addError("JsonFormatter failed.  Defaulting to map.toString().  Message: " + e.getMessage(), e);
            return map.toString();
        }
    }

    protected String formatTimestamp(long timestamp) {
        if (this.timestampFormat == null || timestamp < 0L) {
            return String.valueOf(timestamp);
        }
        Date date = new Date(timestamp);
        DateFormat format = this.createDateFormat(this.timestampFormat);
        if (this.timestampFormatTimezoneId != null) {
            TimeZone tz = TimeZone.getTimeZone(this.timestampFormatTimezoneId);
            format.setTimeZone(tz);
        }
        return this.format(date, format);
    }

    protected DateFormat createDateFormat(String timestampFormat) {
        return new SimpleDateFormat(timestampFormat);
    }

    protected String format(Date date, DateFormat format) {
        return format.format(date);
    }

    protected abstract Map toJsonMap(E var1);

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public JsonFormatter getJsonFormatter() {
        return this.jsonFormatter;
    }

    public void setJsonFormatter(JsonFormatter jsonFormatter) {
        this.jsonFormatter = jsonFormatter;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public String getTimestampFormatTimezoneId() {
        return this.timestampFormatTimezoneId;
    }

    public void setTimestampFormatTimezoneId(String timestampFormatTimezoneId) {
        this.timestampFormatTimezoneId = timestampFormatTimezoneId;
    }

    public boolean isAppendLineSeparator() {
        return this.appendLineSeparator;
    }

    public void setAppendLineSeparator(boolean appendLineSeparator) {
        this.appendLineSeparator = appendLineSeparator;
    }
}

