/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.filtering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.OperationAbandonedException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryFilteringCursorImpl
extends AbstractCursor<Entry>
implements EntryFilteringCursor {
    private static final Logger LOG = LoggerFactory.getLogger(EntryFilteringCursorImpl.class);
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final Cursor<Entry> wrapped;
    private final SearchOperationContext operationContext;
    private final SchemaManager schemaManager;
    private final List<EntryFilter> filters;
    private Entry prefetched;

    public EntryFilteringCursorImpl(Cursor<Entry> wrapped, SearchOperationContext operationContext, SchemaManager schemaManager, EntryFilter filter) {
        this(wrapped, operationContext, schemaManager, Collections.singletonList(filter));
    }

    public EntryFilteringCursorImpl(Cursor<Entry> wrapped, SearchOperationContext operationContext, SchemaManager schemaManager) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped = wrapped;
        this.operationContext = operationContext;
        this.filters = new ArrayList<EntryFilter>();
        this.schemaManager = schemaManager;
    }

    public EntryFilteringCursorImpl(Cursor<Entry> wrapped, SearchOperationContext operationContext, SchemaManager schemaManager, List<EntryFilter> filters) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped = wrapped;
        this.operationContext = operationContext;
        this.filters = new ArrayList<EntryFilter>();
        this.filters.addAll(filters);
        this.schemaManager = schemaManager;
    }

    public boolean isAbandoned() {
        return this.operationContext.isAbandoned();
    }

    public void setAbandoned(boolean abandoned) {
        this.operationContext.setAbandoned(abandoned);
        if (abandoned) {
            LOG.info("Cursor has been abandoned.");
        }
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        return this.filters.add(filter);
    }

    public boolean removeEntryFilter(EntryFilter filter) {
        return this.filters.remove(filter);
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public SearchOperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public void after(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.wrapped.afterLast();
        this.prefetched = null;
    }

    @Override
    public boolean available() {
        return this.prefetched != null;
    }

    @Override
    public void before(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.wrapped.beforeFirst();
        this.prefetched = null;
    }

    @Override
    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped.close();
        this.prefetched = null;
    }

    @Override
    public void close(Exception reason) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped.close(reason);
        this.prefetched = null;
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.wrapped.setClosureMonitor(monitor);
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        if (this.operationContext.isAbandoned()) {
            LOG.info("Cursor has been abandoned.");
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw new LdapException(ioe.getMessage(), ioe);
            }
            throw new OperationAbandonedException();
        }
        this.beforeFirst();
        return this.next();
    }

    @Override
    public Entry get() throws InvalidCursorPositionException {
        if (this.available()) {
            return this.prefetched;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        if (this.operationContext.isAbandoned()) {
            LOG.info("Cursor has been abandoned.");
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw new LdapException(ioe.getMessage(), ioe);
            }
            throw new OperationAbandonedException();
        }
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        if (this.operationContext.isAbandoned()) {
            LOG.info("Cursor has been abandoned.");
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw new LdapException(ioe.getMessage(), ioe);
            }
            throw new OperationAbandonedException();
        }
        Entry tempResult = null;
        block2: while (this.wrapped.next()) {
            Entry tempEntry = this.wrapped.get();
            if (tempEntry == null) continue;
            tempResult = tempEntry instanceof ClonedServerEntry ? tempEntry : new ClonedServerEntry(tempEntry);
            if (this.filters.isEmpty()) {
                this.prefetched = tempResult;
                ServerEntryUtils.filterContents(this.schemaManager, this.operationContext, this.prefetched);
                return true;
            }
            if (this.filters.size() == 1 && this.filters.get(0).accept(this.operationContext, tempResult)) {
                this.prefetched = tempResult;
                ServerEntryUtils.filterContents(this.schemaManager, this.operationContext, this.prefetched);
                return true;
            }
            for (EntryFilter filter : this.filters) {
                if (filter.accept(this.operationContext, tempResult)) continue;
                continue block2;
            }
            this.prefetched = tempResult;
            return true;
        }
        this.prefetched = null;
        return false;
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        if (this.operationContext.isAbandoned()) {
            LOG.info("Cursor has been abandoned.");
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw new LdapException(ioe.getMessage(), ioe);
            }
            throw new OperationAbandonedException();
        }
        ClonedServerEntry tempResult = null;
        block2: while (this.wrapped.previous()) {
            Entry entry = this.wrapped.get();
            if (entry == null) continue;
            tempResult = new ClonedServerEntry(entry);
            if (this.filters.isEmpty()) {
                this.prefetched = tempResult;
                ServerEntryUtils.filterContents(this.schemaManager, this.operationContext, this.prefetched);
                return true;
            }
            if (this.filters.size() == 1 && this.filters.get(0).accept(this.operationContext, tempResult)) {
                this.prefetched = tempResult;
                ServerEntryUtils.filterContents(this.schemaManager, this.operationContext, this.prefetched);
                return true;
            }
            for (EntryFilter filter : this.filters) {
                if (filter.accept(this.operationContext, tempResult)) continue;
                continue block2;
            }
            this.prefetched = tempResult;
            ServerEntryUtils.filterContents(this.schemaManager, this.operationContext, this.prefetched);
            return true;
        }
        this.prefetched = null;
        return false;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        if (this.wrapped != null) {
            sb.append(tabs).append("BaseEntryFilteringCursor, wrapped : \n");
            sb.append(this.wrapped.toString(tabs + "    "));
        } else {
            sb.append(tabs).append("BaseEntryFilteringCursor, no wrapped\n");
        }
        if (this.filters != null && this.filters.size() > 0) {
            sb.append(tabs).append("Filters : \n");
            for (EntryFilter filter : this.filters) {
                sb.append(filter.toString(tabs + "    ")).append("\n");
            }
        } else {
            sb.append(tabs).append("No filter\n");
        }
        if (this.prefetched != null) {
            sb.append(tabs).append("Prefetched : \n");
            sb.append(this.prefetched.toString(tabs + "    "));
        } else {
            sb.append(tabs).append("No prefetched");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

