/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.List;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorContext
implements IoHandlerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(MonitorContext.class);
    private String contextKey = "context";

    @Override
    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        if (LOG.isDebugEnabled()) {
            try {
                DnsContext dnsContext = (DnsContext)session.getAttribute(this.getContextKey());
                RecordStore store = dnsContext.getStore();
                List<ResourceRecord> records = dnsContext.getResourceRecords();
                StringBuffer sb = new StringBuffer();
                sb.append("Monitoring context:");
                sb.append("\n\tstore:                     " + store);
                sb.append("\n\trecords:                   " + records);
                LOG.debug(sb.toString());
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_154, new Object[0]), e);
            }
        }
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

