/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.net.URI;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.impl.avl.AvlTable;

public class AvlIndex<K>
extends AbstractIndex<K, String> {
    protected Normalizer normalizer;
    protected AvlTable<K, String> forward;
    protected AvlTable<String, K> reverse;

    public AvlIndex() {
        super(true);
    }

    public AvlIndex(String attributeId) {
        super(attributeId, true);
    }

    public AvlIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws Exception {
        this.attributeType = attributeType;
        MatchingRule mr = attributeType.getEquality();
        if (mr == null) {
            mr = attributeType.getOrdering();
        }
        if (mr == null) {
            mr = attributeType.getSubstring();
        }
        this.normalizer = mr.getNormalizer();
        if (this.normalizer == null) {
            throw new Exception(I18n.err(I18n.ERR_212, attributeType));
        }
        LdapComparator<? super Object> comp = mr.getLdapComparator();
        this.forward = new AvlTable<Object, String>(attributeType.getName(), comp, UuidComparator.INSTANCE, true);
        if (this.withReverse) {
            this.reverse = attributeType.isSingleValued() ? new AvlTable<String, Object>(attributeType.getName(), UuidComparator.INSTANCE, comp, false) : new AvlTable<String, Object>(attributeType.getName(), UuidComparator.INSTANCE, comp, true);
        }
    }

    @Override
    public void add(K attrVal, String id) throws Exception {
        this.forward.put(attrVal, id);
        if (this.withReverse) {
            this.reverse.put(id, (String)attrVal);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.forward != null) {
            this.forward.close();
        }
        if (this.reverse != null) {
            this.reverse.close();
        }
    }

    @Override
    public long count() throws Exception {
        return this.forward.count();
    }

    @Override
    public long count(K attrVal) throws Exception {
        return this.forward.count(attrVal);
    }

    @Override
    public void drop(String id) throws Exception {
        if (this.withReverse) {
            if (this.isDupsEnabled()) {
                Cursor<Tuple<String, K>> cursor = this.reverse.cursor(id);
                while (cursor.next()) {
                    Tuple<String, K> tuple = cursor.get();
                    this.forward.remove(tuple.getValue(), id);
                }
                cursor.close();
            } else {
                K key = this.reverse.get(id);
                this.forward.remove(key);
            }
            this.reverse.remove(id);
        }
    }

    @Override
    public void drop(K attrVal, String id) throws Exception {
        this.forward.remove(attrVal, id);
        if (this.withReverse) {
            this.reverse.remove(id, (String)attrVal);
        }
    }

    @Override
    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(attrVal);
    }

    @Override
    public boolean forward(K attrVal, String id) throws LdapException {
        return this.forward.has(attrVal, id);
    }

    @Override
    public Cursor<IndexEntry<K, String>> forwardCursor() throws LdapException {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    @Override
    public Cursor<IndexEntry<K, String>> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    @Override
    public String forwardLookup(K attrVal) throws Exception {
        return this.forward.get(attrVal);
    }

    @Override
    public Cursor<String> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    @Override
    public long greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(attrVal);
    }

    @Override
    public long lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(attrVal);
    }

    @Override
    public boolean reverse(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.has(id);
        }
        return false;
    }

    @Override
    public boolean reverse(String id, K attrVal) throws Exception {
        if (this.withReverse) {
            return this.reverse.has(id, (String)attrVal);
        }
        return false;
    }

    @Override
    public Cursor<IndexEntry<K, String>> reverseCursor() throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(), false);
        }
        return new EmptyIndexCursor();
    }

    @Override
    public Cursor<IndexEntry<K, String>> reverseCursor(String id) throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(id), false);
        }
        return new EmptyIndexCursor();
    }

    @Override
    public K reverseLookup(String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.get(id);
        }
        return null;
    }

    @Override
    public Cursor<K> reverseValueCursor(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.valueCursor(id);
        }
        return new EmptyCursor();
    }

    @Override
    public void setWkDirPath(URI wkDirPath) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_213, new Object[0]));
    }

    @Override
    public URI getWkDirPath() {
        return null;
    }

    @Override
    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }

    @Override
    public void sync() throws Exception {
    }
}

