/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.shell.AbstractCredentialCollector;
import org.apache.knox.gateway.shell.CredentialCollectionException;
import org.apache.knox.gateway.util.JsonUtils;

public class KnoxTokenCredentialCollector
extends AbstractCredentialCollector {
    public static final String COLLECTOR_TYPE = "KnoxToken";
    private static final String KNOXTOKENCACHE = ".knoxtokencache";
    private String targetUrl = null;
    private String tokenType = null;

    @Override
    public void collect() throws CredentialCollectionException {
        block4: {
            String userDir = System.getProperty("user.home");
            File knoxtoken = new File(userDir, KNOXTOKENCACHE);
            if (knoxtoken.exists()) {
                Path path = Paths.get(knoxtoken.toURI());
                try {
                    List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                    Map attrs = JsonUtils.getMapFromJsonString((String)lines.get(0));
                    this.value = (String)attrs.get("access_token");
                    this.targetUrl = (String)attrs.get("target_url");
                    this.tokenType = (String)attrs.get("token_type");
                    Date expires = new Date(Long.parseLong((String)attrs.get("expires_in")));
                    if (expires.before(new Date())) {
                        throw new CredentialCollectionException("Cached knox token has expired. Please relogin through knoxinit.");
                    }
                    break block4;
                }
                catch (IOException e) {
                    throw new CredentialCollectionException("Cached knox token cannot be read. Please login through knoxinit.", e);
                }
            }
            throw new CredentialCollectionException("Cached knox token cannot be found. Please login through knoxinit.");
        }
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public String type() {
        return COLLECTOR_TYPE;
    }
}

