/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hostmap.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributor;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.hostmap.api.HostmapFunctionDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;

public class HostmapDeploymentContributor
extends ProviderDeploymentContributorBase
implements ProviderDeploymentContributor {
    public static final String PROVIDER_ROLE_NAME = "hostmap";
    public static final String PROVIDER_IMPL_NAME = "static";
    private static final String REWRITE_ROLE_NAME = "rewrite";

    public String getRole() {
        return PROVIDER_ROLE_NAME;
    }

    public String getName() {
        return PROVIDER_IMPL_NAME;
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        HostmapFunctionDescriptor func;
        UrlRewriteRulesDescriptor rules;
        if (provider.isEnabled() && (rules = (UrlRewriteRulesDescriptor)context.getDescriptor(REWRITE_ROLE_NAME)) != null && (func = (HostmapFunctionDescriptor)rules.addFunction(PROVIDER_ROLE_NAME)) != null) {
            Asset asset = this.createAsset(provider);
            context.getWebArchive().addAsWebInfResource(asset, "hostmap.txt");
            func.config("/WEB-INF/hostmap.txt");
        }
    }

    private Asset createAsset(Provider provider) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        for (Map.Entry entry : provider.getParams().entrySet()) {
            String externalHosts = (String)entry.getKey();
            String internalHosts = (String)entry.getValue();
            writer.print(externalHosts);
            writer.print("=");
            writer.println(internalHosts);
        }
        writer.close();
        String string = buffer.toString();
        StringAsset asset = new StringAsset(string);
        return asset;
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }
}

