/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hive;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Default;
import org.apache.knox.gateway.ha.dispatch.DefaultHaDispatch;
import org.apache.knox.gateway.hive.HiveDispatchUtils;

public class HiveHaDispatch
extends DefaultHaDispatch {
    private boolean basicAuthPreemptive = false;

    public HiveHaDispatch() {
        this.setServiceRole("HIVE");
    }

    protected void addCredentialsToRequest(HttpUriRequest request) {
        if (this.isBasicAuthPreemptive()) {
            HiveDispatchUtils.addCredentialsToRequest(request);
        }
    }

    @Configure
    public void setBasicAuthPreemptive(@Default(value="false") boolean basicAuthPreemptive) {
        this.basicAuthPreemptive = basicAuthPreemptive;
    }

    public boolean isBasicAuthPreemptive() {
        return this.basicAuthPreemptive;
    }
}

